<?php
function streamit_display_header()
{
    $streamit_option = get_option('streamit_options');
    if (!is_front_page() && !is_singular('person') && !is_singular('video' ) && !is_singular('tv_show') && !is_singular('movie') && !is_singular('episode') ) {

        if (((is_page() && !streamit_is_frontpage())) && has_post_thumbnail(get_queried_object_id())) {
            $options = '';

            if(isset($streamit_option['bg_opacity'])) {
                $options = $streamit_option['bg_opacity'];
            }

            if ($options == "1")
            {
                $bg_class = esc_attr__('iq-bg-over black', 'streamit');
            }
            elseif ($options == "2")
            {
                $bg_class = esc_attr__('iq-bg-over iq-over-dark-50', 'streamit');
            }
            elseif ($options == "3")
            {
                $bg_class = esc_attr__('breadcrumb-bg breadcrumb-ui', 'streamit');
            }
            else
            {
                $bg_class = esc_attr__('iq-bg-over iq-over-dark-50', 'streamit');
            } ?>
            <div class="text-left iq-breadcrumb-one <?php if(!empty($bg_class)){ echo esc_attr($bg_class); } ?>"> <?php

        } else {

            if (!empty($streamit_option['bg_type']) && $streamit_option['bg_type'] == "1" ) {

                $bg_color = esc_attr__('iq-bg-over black', 'streamit');

            } elseif (!empty($streamit_option['bg_type']) && $streamit_option['bg_type'] == "2" ) {

                if (isset($streamit_option['banner_image']['url'])) {
                    $bgurl = $streamit_option['banner_image']['url'];
                }

                $options = $streamit_option['bg_opacity'];

                if ($options == "1") {
                } elseif ($options == "2") {
                    $bg_class = esc_attr__('iq-bg-over iq-over-dark-50', 'streamit');
                } elseif ($options == "3") {
                    $bg_class = esc_attr__('breadcrumb-bg breadcrumb-ui', 'streamit');
                } else {
                    $bg_class = esc_attr__('iq-bg-over iq-over-dark-50', 'streamit');

                }

            } elseif ( !empty($streamit_option['bg_type']) && $streamit_option['bg_type'] == "3" ) {

                $options = $streamit_option['bg_opacity'];

                if ($options == "1") {
                    $bg_class = esc_attr__('video-iq-bg-over', 'streamit');
                } elseif ($options == "2") {
                    $bg_class = esc_attr__('video-breadcrumb-bg breadcrumb-video', 'streamit');
                } elseif ($options == "3") {
                    $bg_class = esc_attr__('video-breadcrumb-bg breadcrumb-video', 'streamit');
                } else {
                    $bg_class = esc_attr__('iq-bg-over iq-over-dark-50', 'streamit');
                }
            } else {
                $bg_class = esc_attr__('iq-bg-over', 'streamit');
            } ?>

            <div class="iq-breadcrumb-one <?php if ( isset($streamit_option['bg_type']) && !empty($streamit_option['bg_type'] == "1")) {
                echo esc_attr($bg_color);
            } ?> <?php if (!empty($bg_class))
            {
                echo esc_attr($bg_class);
            } ?>" <?php if (!empty($bgurl)) { ?> style="background-image: url(<?php echo esc_url($bgurl); ?> );" <?php } ?>> <?php
        } ?> <?php

        if (!empty($streamit_option['bg_type']) && $streamit_option['bg_type'] == "3") {

            if (isset($streamit_option['bg_video_link'])) {
                $videourl = $streamit_option['bg_video_link'];
            } ?>

            <video class="masthead-video" autoplay loop muted>
                <source src="<?php echo esc_url($videourl); ?>" type="video/mp4">
                <source src="<?php echo esc_url($videourl); ?>" type="video/webm">
            </video> <?php
        } ?>

        <div class="container-fluid"> <?php

            $options = '';

            if(!empty($streamit_option['bg_image'])) {
                $options = $streamit_option['bg_image'];
            }

            if ($options == '1' && class_exists( 'ReduxFramework' ) ) {    ?>

                <div class="row align-items-center">
                    <div class="col-sm-12">
                        <nav aria-label="breadcrumb" class="text-center iq-breadcrumb-two">
                            <?php
                            echo streamit_breadcrumbs_title();
                            if (isset($streamit_option['display_breadcrumbs']))
                            {
                                $options = $streamit_option['display_breadcrumbs'];
                                if ($options == "yes")
                                {
                                    ?>
                                    <ol class="breadcrumb main-bg">
                                        <?php echo streamit_custom_breadcrumbs(); ?>
                                    </ol>
                                    <?php
                                }
                            }
                            ?>
                        </nav>
                    </div>
                </div> <?php

            } elseif ($options == '2' && class_exists( 'ReduxFramework' ) ) { ?>

                <div class="row align-items-center">
                    <div class="col-lg-8 col-md-8 text-left align-self-center">
                        <nav aria-label="breadcrumb" class="text-left"> <?php
                            echo streamit_breadcrumbs_title();
                            if (isset($streamit_option['display_breadcrumbs'])) {
                                $options = $streamit_option['display_breadcrumbs'];
                                if ($options == "yes") { ?>
                                    <ol class="breadcrumb main-bg">
                                        <?php echo streamit_custom_breadcrumbs(); ?>
                                    </ol> <?php
                                }
                            } ?>
                        </nav>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-12 text-right wow fadeInRight">
                        <?php echo streamit_breadcrumbs_feature_image(); ?>
                    </div>
                </div> <?php

            } elseif ($options == '3' && class_exists( 'ReduxFramework' ) ) { ?>

                <div class="row align-items-center">
                    <div class="col-lg-4 col-md-4 col-sm-12 wow fadeInLeft">
                        <?php echo streamit_breadcrumbs_feature_image(); ?>
                    </div>
                    <div class="col-lg-8 col-md-8 text-left align-self-center">
                        <nav aria-label="breadcrumb" class="text-right iq-breadcrumb-two"> <?php
                            echo streamit_breadcrumbs_title();
                            if (isset($streamit_option['display_breadcrumbs'])) {
                                $options = $streamit_option['display_breadcrumbs'];
                                if ($options == "yes") { ?>
                                    <ol class="breadcrumb main-bg">
                                        <?php echo streamit_custom_breadcrumbs(); ?>
                                    </ol> <?php
                                }
                            } ?>
                        </nav>
                    </div>
                </div> <?php

            } elseif ($options == '4' && class_exists( 'ReduxFramework' ) ) { ?>

                <div class="row align-items-center iq-breadcrumb-three">
                    <div class="col-sm-6 mb-3 mb-lg-0 mb-md-0">
                        <?php echo streamit_breadcrumbs_title(); ?>
                    </div>
                    <div class="col-sm-6 ext-lg-right text-md-right text-sm-left">
                        <nav aria-label="breadcrumb" class="iq-breadcrumb-two"> <?php
                            if (isset($streamit_option['display_breadcrumbs'])) {
                                $options = $streamit_option['display_breadcrumbs'];
                                if ($options == "yes") { ?>
                                    <ol class="breadcrumb main-bg">
                                        <?php echo streamit_custom_breadcrumbs(); ?>
                                    </ol> <?php
                                }
                            } ?>
                        </nav>
                    </div>
                </div> <?php

            } elseif ($options == '5' && class_exists( 'ReduxFramework' ) ) { ?>

                <div class="row align-items-center iq-breadcrumb-three">
                    <div class="col-sm-6 mb-3 mb-lg-0 mb-md-0">
                        <nav aria-label="breadcrumb" class="text-left iq-breadcrumb-two">
                            <?php
                            if (isset($streamit_option['display_breadcrumbs']))
                            {
                                $options = $streamit_option['display_breadcrumbs'];
                                if ($options == "yes")
                                {
                                    ?>
                                    <ol class="breadcrumb main-bg">
                                        <?php echo streamit_custom_breadcrumbs(); ?>
                                    </ol>
                                    <?php
                                }
                            }
                            ?>
                        </nav>
                    </div>
                    <div class="col-sm-6 text-right">
                        <?php echo streamit_breadcrumbs_title(); ?>
                    </div>
                </div> <?php

            } else  { ?>

                <div class="row align-items-center">
                    <div class="col-sm-12">
                        <nav aria-label="breadcrumb" class="text-center"> <?php
                            echo streamit_breadcrumbs_title(); ?>
                            <ol class="breadcrumb main-bg">
                                <?php echo streamit_custom_breadcrumbs(); ?>
                            </ol>
                        </nav>
                    </div>
                </div> <?php

            } ?>

        </div>
        </div>
        <?php
    }
}
