<?php
if(!class_exists('ReduxFramework'))
{
    return;
}

add_action( 'wp_head', 'streamit_header_sticky_background_style' );
add_action( 'wp_enqueue_scripts', 'streamit_sticky_menu_color_options' , 20);
add_action( 'wp_enqueue_scripts', 'streamit_sticky_sub_menu_color_options' , 20);

function streamit_header_sticky_background_style()
{
    $streamit_options = get_option('streamit_options');
    $dynamic_css = array();
    
    if(function_exists('get_field'))
    {
        $page_id_header = get_queried_object_id();

        $key_header_back = get_field('key_dark_header' , $page_id_header);
        $key_header_style = get_field('key_header' , $page_id_header);
        if(isset($key_header_style['header_variation']))
        $header_style = $key_header_style['header_variation'];
        if(isset($key_header_back['name_menu_has_dark']))
        $has_dark = $key_header_back['name_menu_has_dark'];
        if(isset($key_header_back['name_back_color']))
        $back_color = $key_header_back['name_back_color'];

    }

    if( isset($has_dark) && $has_dark == 'yes' && isset($back_color) && !empty($back_color)  && isset($header_style) && $header_style != '3' )
    {
        $dynamic_css[] = array(
        'elements'  =>  'header.menu-sticky .main-header,header#main-header.has-sticky.menu-sticky',
        'property'  =>  'background',
        'value'     =>  ''.$back_color.' !important'
        );
    }
    else if(isset($streamit_options['sticky_header_background_type']) && $streamit_options['sticky_header_background_type'] != 'default')
    {
        $type = $streamit_options['sticky_header_background_type'];
        if($type == 'color')
        {
            if(!empty($streamit_options['sticky_header_background_color']))
            {
                $dynamic_css[] = array(
                'elements'  =>  'header.menu-sticky .main-header,header#main-header.has-sticky.menu-sticky',
                'property'  =>  'background',
                'value'     =>  ''.$streamit_options['sticky_header_background_color'].' !important'
                );
            }

        }

        if($type == 'image')
        {
            if(!empty($streamit_options['sticky_header_background_image']['url']))
            {
                $dynamic_css[] = array(
                'elements'  =>  'header.menu-sticky .main-header,header#main-header.has-sticky.menu-sticky',
                'property'  =>  'background',
                'value'     =>  'url('.$streamit_options['sticky_header_background_image']['url'].') !important'
                );
            }

        }

        if($type == 'transparent')
        {

            $dynamic_css[] = array(
            'elements'  =>  'header.menu-sticky .main-header,header#main-header.has-sticky.menu-sticky',
            'property'  =>  'background',
            'value'     =>  'transparent !important'
            );


        }
    }else{}

    if ( count( $dynamic_css ) > 0 )
    {
        echo "<style type='text/css' id='streamit-dynamic-css".rand(10,100000)."'>\n\n";
            streamit_dynamic_style( $dynamic_css );
        echo '</style>';
    }

    

}



function streamit_sticky_menu_color_options()
{
    $streamit_options = get_option('streamit_options');
    $inline_css = '';
     if(isset($streamit_options['sticky_menu_color_type']) && $streamit_options['sticky_menu_color_type'] == 'custom')
    {

        if(isset($streamit_options['sticky_menu_color']) && !empty($streamit_options['sticky_menu_color']))
        {
            $inline_css .= 'header.menu-sticky .navbar ul li a,header.menu-sticky .navbar ul li i{
                color : '.$streamit_options['sticky_menu_color'].'!important;
            }';
        }
        if(isset($streamit_options['sticky_menu_active_color']) && !empty($streamit_options['sticky_menu_active_color']))
        {
            $inline_css .= 'header.menu-sticky .navbar ul li.current-menu-item a, header.menu-sticky .navbar ul li.current-menu-parent a, header.menu-sticky .navbar ul li.current-menu-parent i, header.menu-sticky .navbar ul li.current-menu-item i,header.menu-sticky .navbar ul li.current-menu-ancestor a,header.menu-sticky .navbar ul li.current-menu-ancestor i{
                color : '.$streamit_options['sticky_menu_active_color'].'!important;
            }';
        }
        if(isset($streamit_options['sticky_menu_hover_color']) && !empty($streamit_options['sticky_menu_hover_color']))
        {
            $inline_css .= 'header.menu-sticky .navbar ul li:hover a,header.menu-sticky .navbar ul li:hover i{
                color : '.$streamit_options['sticky_menu_hover_color'].'!important;
            }';
        }
               
    }

    if(!empty($inline_css))
    {
        wp_add_inline_style('streamit-style', $inline_css);
    }
    
}

function streamit_sticky_sub_menu_color_options()
{
    $streamit_options = get_option('streamit_options');
    $inline_css = '';
    
    if(isset($streamit_options['sticky_header_submenu_color_type']) && $streamit_options['sticky_header_submenu_color_type'] == 'custom')
    {
        if(isset($streamit_options['sticky_streamit_header_submenu_color']) && !empty($streamit_options['sticky_streamit_header_submenu_color']))
        {
            $inline_css .= 'header.menu-sticky .navbar ul li .sub-menu li a,header.menu-sticky .navbar ul li .sub-menu li.current-menu-parent .sub-menu  li a, header.menu-sticky .navbar ul li .sub-menu li:hover .sub-menu li a,header.menu-sticky .navbar ul li .sub-menu li i,header.menu-sticky .navbar ul li .sub-menu li.current-menu-parent .sub-menu  li i, header.menu-sticky .navbar ul li .sub-menu li:hover .sub-menu li i,header.menu-sticky .navbar ul li .sub-menu li:hover .sub-menu li a,header.menu-sticky .navbar ul li .sub-menu li:hover .sub-menu li i{
                color : '.$streamit_options['sticky_streamit_header_submenu_color'].' !important;
            }';
        }

        if(isset($streamit_options['sticky_streamit_header_submenu_active_color']) && !empty($streamit_options['sticky_streamit_header_submenu_active_color']))
        {
            $inline_css .= 'header.menu-sticky .navbar ul li .sub-menu li.current-menu-item a,header.menu-sticky .navbar ul li .sub-menu li.current-menu-item i,header.menu-sticky .navbar ul li .sub-menu li.current-menu-ancestor a,header.menu-sticky .navbar ul li .sub-menu li.current-menu-ancestor i,header.menu-sticky .navbar ul li .sub-menu li.current-menu-parent .sub-menu li.current-menu-item  a,header.menu-sticky .navbar ul li .sub-menu li.current-menu-parent .sub-menu li.current-menu-item  i{
                color : '.$streamit_options['sticky_streamit_header_submenu_active_color'].' !important;
            }';
        }

        if(isset($streamit_options['sticky_streamit_header_submenu_hover_color']) && !empty($streamit_options['sticky_streamit_header_submenu_hover_color']))
        {
            $inline_css .= 'header.menu-sticky .navbar ul li .sub-menu li:hover a,header.menu-sticky .navbar ul li .sub-menu li:hover i,header.menu-sticky .navbar ul li .sub-menu li.current-menu-parent:hover a, header.menu-sticky .navbar ul li .sub-menu li.current-menu-parent .sub-menu li:hover a, header.menu-sticky .navbar ul li .sub-menu li.current-menu-parent:hover .sub-menu li:hover a,header.menu-sticky .navbar ul li .sub-menu li.current-menu-parent:hover i, header.menu-sticky .navbar ul li .sub-menu li.current-menu-parent .sub-menu li:hover i, header.menu-sticky .navbar ul li .sub-menu li.current-menu-parent:hover .sub-menu li:hover i,header.menu-sticky .navbar ul li .sub-menu li:hover .sub-menu li:hover a,header.menu-sticky .navbar ul li .sub-menu li:hover .sub-menu li:hover i{
                color : '.$streamit_options['sticky_streamit_header_submenu_hover_color'].' !important;
            }';
        }

        if(isset($streamit_options['sticky_streamit_header_submenu_background_color']) && !empty($streamit_options['sticky_streamit_header_submenu_background_color']))
        {
            $inline_css .= 'header.menu-sticky .navbar ul li .sub-menu li a,header.menu-sticky .navbar ul li .sub-menu li.current-menu-parent li a,header.menu-sticky .navbar ul li .sub-menu li.current-menu-parent:hover .sub-menu li a,header.menu-sticky .navbar ul li .sub-menu li:hover .sub-menu li a,header.menu-sticky .navbar ul li .sub-menu li:hover .sub-menu li a {
                background : '.$streamit_options['sticky_streamit_header_submenu_background_color'].' !important;
            }';
        }

        if(isset($streamit_options['sticky_header_submenu_background_hover_color']) && !empty($streamit_options['sticky_header_submenu_background_hover_color']))
        {
            $inline_css .= 'header.menu-sticky .navbar ul li .sub-menu li:hover a,header.menu-sticky .navbar ul li .sub-menu li.current-menu-parent:hover a,header.menu-sticky .navbar ul li .sub-menu li.current-menu-parent .sub-menu li:hover a,header.menu-sticky .navbar ul li .sub-menu li.current-menu-parent:hover .sub-menu li:hover a,header.menu-sticky .navbar ul li .sub-menu li:hover .sub-menu li:hover a{
                background : '.$streamit_options['sticky_header_submenu_background_hover_color'].' !important;
            }';
        }

          if(isset($streamit_options['sticky_header_submenu_background_active_color']) && !empty($streamit_options['sticky_header_submenu_background_active_color']))
        {
            $inline_css .= 'header.menu-sticky .navbar ul li .sub-menu li.current-menu-item a,header.menu-sticky .navbar ul li .sub-menu li.current-menu-parent a,header.menu-sticky .navbar ul li .sub-menu li.current-menu-parent .sub-menu li.current-menu-item  a {
                background : '.$streamit_options['sticky_header_submenu_background_active_color'].' !important;
            }';
        }
    }    
    if(!empty($inline_css))
    {
        wp_add_inline_style('streamit-style', $inline_css);
    }
}
