<?php
/*
 * Logo Options
 */
$opt_name;
Redux::set_section( $opt_name, array(
    'title' => esc_html__('Logo','streamit'),
    'id'    => 'header-logo',
    'icon'  => 'el el-flag',
    'fields'=> array(

        array(
            'id'       => 'header_radio',
            'type'     => 'button_set',
            'title'    => esc_html__( 'Select Logo Type', 'streamit' ),
            'subtitle' => esc_html__( 'Select either Text or image for your Logo.', 'streamit' ),
            'options'  => array(
                '1' => ' Logo as Text',
                '2' => ' Logo as Image',
            ),
            'default'  => '2'
        ),

        array(
            'id'       => 'streamit_logo',
            'type'     => 'media',
            'url'      => false,
            'title'    => esc_html__( 'Logo','streamit'),
            'required'  => array( 'header_radio', '=', '2' ),
            'read-only'=> false,
            'default'  => array( 'url' => get_template_directory_uri() .'/assets/images/logo.png' ),
            'subtitle' => esc_html__( 'Upload Logo image for your Website. Otherwise site title will be displayed in place of Logo.','streamit'),
        ),

        array(
            'id'             => 'logo-dimensions',
            'type'           => 'dimensions',
            'units'          => array( 'em', 'px', '%' ),    // You can specify a unit value. Possible: px, em, %
            'units_extended' => 'true',  // Allow users to select any type of unit
            'title'          => esc_html__( 'Logo (Width/Height) Option', 'streamit' ),
            'required'  => array( 'header_radio', '=', '2' ),
            'subtitle'       => esc_html__( 'Allows you to choose width, height, and/or unit.', 'streamit' ),
            'desc'           => esc_html__( 'You can enable or disable any piece of this field. Width, Height, or Units.', 'streamit' ),

        ),

        array(
            'id'       => 'header_text',
            'type'     => 'text',
            'title'    => esc_html__( 'Logo Text', 'streamit' ),
            'desc'     => esc_html__( 'Enter the text to be used instead of the logo image', 'streamit' ),
            'required'  => array( 'header_radio', '=', '1' ),
            'msg'      => esc_html__('Please enter correct value','streamit' ),
            'default'  => esc_html__('streamit','streamit' ),
        ),

        array(
            'id'            => 'header_color',
            'type'          => 'color',
            'title'         => esc_html__( 'Text Color', 'streamit' ),
            'subtitle'      => esc_html__( 'Choose Text Color', 'streamit' ),
            'required'      => array( 'header_radio', '=', '1' ),
            'default'       =>'#ffffff',
            'mode'          => 'background',
            'transparent'   => false
        ),
        //---main logo options end---//
         array(
            'id'   =>'divider_1',
            'type' => 'divide'
        ),

        //---logo options for vertical menu start---//
        array(
            'id'        => 'has_vertical_header_logo',
            'type'      => 'button_set',
            'title'     => esc_html__( 'Use different logo for vertical menu ?','streamit'),
            'subtitle'  => esc_html__( 'Select option for set different logo for vertical menu','streamit'),
            'required'  => array( 'streamit_header_variation', '=', '3' ),
            'options'   => array(
                            'yes' => esc_html__('Yes','streamit'),
                            'no' => esc_html__('No','streamit'),
                        ),
            'default'   => esc_html__('no','streamit')
        ),

        array(
            'id'       => 'vertical_header_radio',
            'type'     => 'button_set',
            'title'    => esc_html__( 'Select Logo Type', 'streamit' ),
            'subtitle' => esc_html__( 'Select either Text or image for your Logo.', 'streamit' ),
            'required'  => array( 'has_vertical_header_logo', '=', 'yes' ),
            'options'  => array(
                '1' => ' Logo as Text',
                '2' => ' Logo as Image',
            ),
            'default'  => '2'
        ),

        array(
            'id'       => 'streamit_vertical_logo',
            'type'     => 'media',
            'url'      => false,
            'title'    => esc_html__( 'Logo','streamit'),
            'required'  => array( 'vertical_header_radio', '=', '2' ),
            'read-only'=> false,
            'default'  => array( 'url' => get_template_directory_uri() .'/assets/images/logo.png' ),
            'subtitle' => esc_html__( 'Upload Logo image for your website vertical menu. Otherwise site title will be displayed in place of Logo.','streamit'),
        ),

        array(
            'id'             => 'vertical-logo-dimensions',
            'type'           => 'dimensions',
            'units'          => array( 'em', 'px', '%' ),    // You can specify a unit value. Possible: px, em, %
            'units_extended' => 'true',  // Allow users to select any type of unit
            'title'          => esc_html__( 'Logo (Width/Height) Option', 'streamit' ),
            'required'  => array( 'vertical_header_radio', '=', '2' ),
            'subtitle'       => esc_html__( 'Allows you to choose width, height, and/or unit.', 'streamit' ),
            'desc'           => esc_html__( 'You can enable or disable any piece of this field. Width, Height, or Units.', 'streamit' ),

        ),

        array(
            'id'       => 'vertical_header_text',
            'type'     => 'text',
            'title'    => esc_html__( 'Logo Text', 'streamit' ),
            'desc'     => esc_html__( 'Enter the text to be used instead of the logo image', 'streamit' ),
            'required'  => array( 'vertical_header_radio', '=', '1' ),
            'msg'      => esc_html__('custom error message','streamit' ),
            'default'  => esc_html__('streamit','streamit' ),
        ),

        array(
            'id'            => 'vertical_header_color',
            'type'          => 'color',
            'title'         => esc_html__( 'Text Color', 'streamit' ),
            'subtitle'      => esc_html__( 'Choose Text Color', 'streamit' ),
            'required'      => array( 'vertical_header_radio', '=', '1' ),
            'default'       =>'#ffffff',
            'mode'          => 'background',
            'transparent'   => false
        ),
        //---logo options for vertical menu start---//
    )
));
