<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

class Iq_Movie_TV_Banner_Slider extends Widget_Base
{

	public function get_name()
	{
		return __('Iq_Movie_TV_Banner_Slider', "streamit-extensions");
	}

	public function get_title()
	{
		return __('Movie / Tv Show / Video Slider', "streamit-extensions");
	}

	public function get_categories()
	{
		return ['streamit-extensions'];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve heading widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-person';
	}



	protected function _register_controls()
	{


		$this->start_controls_section(
			'section_Team',
			[
				'label' => __('Movie / Tv Show /Video Banner Slider', "streamit-extensions"),
			]
		);

		$this->add_control(
			'show_view_all_btn',
			[
				'label'   => __('Show Play Now Button', "streamit-extensions"),
				'type'    => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => esc_html__('yes', "streamit-extensions"),
					'no' => esc_html__('no', "streamit-extensions")
				],

			]
		);

		$this->add_control(
			'play_now_text',
			[
				'label' => __('Play Now Text', "streamit-extensions"),
				'type' => Controls_Manager::TEXT,
				'default' => __('Play Now', "streamit-extensions"),
				'label_block' => true,
				'condition' => ['show_view_all_btn' => ['yes']]
			]
		);


		$this->add_control(
			'show_trailer_btn',
			[
				'label' => __('Show Trailer button', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'streamit-extensions'),
				'label_off' => __('Hide', 'streamit-extensions'),
				'return_value' => 'yes',
				'default' => 'yes',

			]
		);
		$this->add_control(
			'trailer_text',
			[
				'label' => __('Trailer Text', "streamit-extensions"),
				'type' => Controls_Manager::TEXT,
				'default' => __('Watch Trailer', "streamit-extensions"),
				'label_block' => true,
				'condition' => ['show_trailer_btn' => ['yes']]
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'iq_type',
			[
				'label' => __('Select Specific Post', "streamit-extensions"),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => [
					'movie' => __('Movie', "streamit-extensions"),
					'tv_show' => __('Tv Show', "streamit-extensions"),
					'video' => __('Video', "streamit-extensions")
				],
				'default' => 'movie'

			]
		);
		$repeater->add_control(
			'iq_tv_show',
			[
				'label' => __('Display Specific Tv-Show', "streamit-extensions"),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => iq_custom_post_data('tv_show', array(), 'id'),
				'condition' => ['iq_type' => ['tv_show']],
			]
		);
		$repeater->add_control(
			'iq_movie',
			[
				'label' => __('Display Specific Movie', "streamit-extensions"),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => iq_custom_post_data('movie', array(), 'id'),
				'condition' => ['iq_type' => ['movie']],
			]
		);
		$repeater->add_control(
			'iq_video',
			[
				'label' => __('Display Specific Video', "streamit-extensions"),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => iq_custom_post_data('video', array(), 'id'),
				'condition' => ['iq_type' => ['video']],
			]
		);
		$repeater->add_control(
			'slider_image',
			[
				'label' => __('Slider  Image', "streamit-extensions"),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],


			]
		);


		$this->add_control(
			'tabs',
			[
				'label' => __('Lists Items', "streamit-extensions"),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);



		$this->end_controls_section();

		$this->start_controls_section(
			'section_slick_control',
			[
				'label' => __('Slider Control', "streamit-extensions"),
			]
		);

		$this->add_control(
			'autoplay',
			[
				'label' => __('Autoplay', 'iqonic'),
				'type' => Controls_Manager::SELECT,
				'default' => 'false',
				'options' => [
					'true' => __('True', 'iqonic'),
					'false' => __('False', 'iqonic'),
				],
			]
		);

		$this->add_control(
			'speed',
			[
				'label' => __('Speed', 'iqonic'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => '1000',
			]
		);

		$this->add_control(
			'nav-arrow',
			[
				'label' => __('Arrow', 'iqonic'),
				'type' => Controls_Manager::SELECT,
				'default' => 'true',
				'options' => [
					'true' => __('True', 'iqonic'),
					'false' => __('False', 'iqonic'),
				],
			]
		);


		$this->add_control(
			'icon_color',
			[
				'label' => __('Icon Color', 'iqonic'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tvshows-slider .NextArrow, {{WRAPPER}} .tvshows-slider .PreArrow' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings();
		require  IQ_TH_ROOT . '/inc/elementor/render/movie-tv-banner-slider.php';
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new \Elementor\Iq_Movie_TV_Banner_Slider());
