<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

class Iq_Genres extends Widget_Base
{

	public function __construct($data = [], $args = null)
	{
		parent::__construct($data, $args);
	}
	public function get_name()
	{
		return __('Iq_Genres', "streamit-extensions");
	}

	public function get_title()
	{
		return __('Iqonic Genres', "streamit-extensions");
	}

	public function get_categories()
	{
		return ['streamit-extensions'];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve heading widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-person';
	}



	protected function _register_controls()
	{


		$this->start_controls_section(
			'section_Genres',
			[
				'label' => __('Genres', "streamit-extensions"),
			]
		);
		$this->add_control(
			'slider_title',
			[
				'label' => __('Title', 'streamit-extensions'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Title', 'streamit-extensions'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'slider_type',
			[
				'label' => __('Movie Style', "streamit-extensions"),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => [
					'slider' => __('Slider', "streamit-extensions"),
					'grid' => __('Grid', "streamit-extensions")
				],
				'default' => 'slider'

			]
		);
		
		$this->add_control(
			'iq_type',
			[
				'label' => __('Select Specific Post', "streamit-extensions"),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => [
					'movie' 	=> __('Movie', "streamit-extensions"),
					'tv_show' 	=> __('Tv Show', "streamit-extensions"),
					'video' 	=> __('Video', "streamit-extensions")
				],
				'default' => 'movie'

			]
		);

		$this->add_control(
			'movie_grid_style',
			[
				'label'      => __('Movie Grid', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'default'    => '4',
				'options'    => [
					'1'            => __('One', 'streamit-extensions'),
					'2'          => __('Two', 'streamit-extensions'),
					'3'          => __('Three', 'streamit-extensions'),
					'4'          => __('Four', 'streamit-extensions'),
				],
				'condition' => ['slider_type' => 'grid']
			]
		);
		$this->add_control(
			'order',
			[
				'label'   => __('Order By', 'streamit-extension'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'ASC',
				'options' => [
					'DESC' => esc_html__('Descending', 'streamit-extension'),
					'ASC' => esc_html__('Ascending', 'streamit-extension')
				],

			]
		);
		$this->add_control(
			'pagination',
			[
				'label'   => __('Show Pagintion/Loadmore/Infinite', 'streamit-extensions'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'loadmore',
				'options' => [
					'yes' => esc_html__('Pagination', 'streamit-extensions'),
					'loadmore' => esc_html__('Loadmore', 'streamit-extensions'),
					'infinite' => esc_html__('Infinite Scroll', 'streamit-extensions')
				],
				'condition' => ['slider_type' => 'grid']

			]
		);
		$this->add_control(
			'more_text',
			[
				'label' => __('Load More button text', 'streamit-extensions'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Load More', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['slider_type' => 'grid', 'pagination' => 'loadmore']
			]
		);
		$this->add_control(
			'loading_text',
			[
				'label' => __('Loading button text', 'streamit-extensions'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Loading...', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['slider_type' => 'grid', 'pagination' => 'loadmore']
			]
		);
		$this->add_responsive_control(
			'posts_per_page',
			[
				'label' => __('Posts Per Page', 'elementor'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => '%',
					'size' => -1,
				],
				'condition' => ['slider_type' => 'grid']
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'slick_control_section',
			[
				'label' => __('Slider Control', 'iqonic'),
				'condition' => ['slider_type' => ['slider']],

			]
		);

		require IQ_TH_ROOT . '/inc/elementor/register-custom-control/slick-control.php';


		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings();
		require  IQ_TH_ROOT . '/inc/elementor/render/iq_genres.php';
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new \Elementor\Iq_Genres());
