<?php

namespace Elementor;

$html = '';
if (!defined('ABSPATH')) exit;
$settings = $this->get_settings();
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
$args = array();
$tax_query = array();
$slider_title = '';
$taxargs = array();
$view_cat = '';
$iq_option = get_option('streamit_options');
$options_streamit_load = $settings['pagination'];
$args = array(
   'post_type'         => 'video',
   'post_status'       => 'publish',
   'paged' => $paged,
   'posts_per_page' => $settings['posts_per_page']['size'],

);
if (!empty($settings['iq_select_videos'])) {
   $args['post__in'] = $settings['iq_select_videos'];
}
if (empty($settings['iq_select_videos']) && $settings['post_view_type'] === 'most_liked') {
   $args['post__in'] = iq_get_most_liked('video', array(), 'id');
   $args['orderby'] = 'post__in';
}
if (empty($settings['iq_select_movies']) && $settings['post_view_type'] === 'most_viewd') {
   $args['meta_key']          = 'post_views_count';
   $args['orderby']           = 'meta_value_num';
   $args['order']             = 'DESC';
}

if (isset($settings['slider_title'])) {
   $slider_title = $settings['slider_title'];
   $slider_title_key  = str_replace(" ", "_", $slider_title);

   $title_option = 'm12iqt' . $slider_title_key;
   if (!get_option($title_option)) {
      update_option($title_option, $slider_title);
   }
   $view_cat = $title_option;
}


if (!empty($settings['iq_video_genre'])) {
   $tax_query['taxonomy'] = 'video_cat';
   $tax_query['field'] = 'slug';
   $tax_query['terms'] = $settings['iq_video_genre'];
   $tax_query['operator'] = 'IN';
   array_push($taxargs, $tax_query);
   $option = '';
   foreach ($settings['iq_video_genre'] as $val) {
      $option .= substr($val, 0, 3);
   }
   $option = 'm12iq_' . $option;
   $option_value = implode(',', $settings['iq_video_genre']);
   if (!get_option($option)) {
      update_option($option, $option_value);
   }
   $view_cat .= '=' . $option;
}


if (!empty($settings['iq_video_tag'])) {
   $tax_query['taxonomy'] = 'video_tag';
   $tax_query['field'] = 'slug';
   $tax_query['terms'] = $settings['iq_video_tag'];
   $tax_query['operator'] = 'IN';
   array_push($taxargs, $tax_query);
   $option = '';
   foreach ($settings['iq_video_tag'] as $val) {
      $option .= substr($val, 0, 3);
   }
   $option = 'm12iq_' . $option;
   $option_value = implode(',', $settings['iq_video_genre']);
   if (!get_option($option)) {
      update_option($option, $option_value);
   }
   $view_cat .= '=' . $option;
}



$view_all = '';


if ($settings['view_all_switch'] === 'yes') {
   $this->add_render_attribute('iq_class', 'class', 'iq-view-all');
   if ($settings['use_custom_link_viewall'] == 'yes') {
      if ($settings['view_all_custom_link']['url']) {
         $url = $settings['view_all_custom_link']['url'];
         $this->add_render_attribute('iq_class', 'href', esc_url($url));

         if ($settings['view_all_custom_link']['is_external']) {
            $this->add_render_attribute('iq_class', 'target', '_blank');
         }

         if ($settings['view_all_custom_link']['nofollow']) {
            $this->add_render_attribute('iq_class', 'rel', 'nofollow');
         }
         $url = '';
      }
      $view_all_text = esc_html($settings['use_custom_link_text']);
      $view_all = '<a ' . $this->get_render_attribute_string('iq_class') . '">' . $view_all_text . '</a>';
   } else {
      $view_all_text = $iq_option['streamit_viewall_text'];
      $view_all = '<a class="iq-view-all" href="' . esc_url(get_page_link($iq_option['streamit_viewall_link'])) . '?videos=' . esc_html($view_cat, "streamit-extensions") . '">' . esc_html($view_all_text, "streamit-extensions") . '</a>';
   }
}


if (!empty($settings['post_view_type']) && $settings['post_view_type'] !== 'none') {
   if ($settings['post_view_type'] === 'latest') {
      $args['orderby'] = 'publish_date';
      $args['order'] = 'DESC';
   }
}
if (!empty($settings['order']) && $settings['post_view_type'] === 'upcoming' || $settings['post_view_type'] === 'none') {
   $args['order'] = $settings['order'];
}
if (!empty($tax_query)) {
   $args['tax_query'] = $taxargs;
   $args['tax_query']['relation'] = 'OR';
}
if ($settings['slider_type'] == 'slider') {
   $align = 'favorites-slider';
} else {
   $align = 'favorites-grid';
}

$this->add_render_attribute('slider', 'data-nav', $settings['nav-arrow']);
$this->add_render_attribute('slider', 'data-items', $settings['desk_number']);
$this->add_render_attribute('slider', 'data-items-laptop', $settings['lap_number']);
$this->add_render_attribute('slider', 'data-items-tab', $settings['tab_number']);
$this->add_render_attribute('slider', 'data-items-mobile', $settings['mob_number']);
$this->add_render_attribute('slider', 'data-items-mobile-sm', $settings['mob_number']);
$this->add_render_attribute('slider', 'data-autoplay', $settings['autoplay']);
$this->add_render_attribute('slider', 'data-speed', $settings['speed']);

$wp_query = new \WP_Query($args);
?>
<div class="favorites-contens <?php if ($settings['slider_type'] == 'grid') {
                                 echo 'watchlist-contens';
                              } else {
                                 echo 'iq-rtl-direction';
                              } ?> streamit_datapass_video" data-options="<?php echo esc_html($options_streamit_load); ?>">
   <div class="iq-main-header d-flex align-items-center justify-content-between <?php if ($settings['slider_type'] == 'slider') {
                                                                                    echo 'iq-ltr-direction';
                                                                                 } ?>">
      <?php
      if (!empty($slider_title)) {
      ?>
         <h4 class="main-title"><?php echo esc_html($slider_title, "streamit-extensions"); ?></h4>
      <?php } ?>
      <?php echo $view_all; ?>
   </div>
   <ul class="<?php echo esc_html($align, "streamit-extensions"); ?> video-list-grid list-inline  row p-0 mb-0" <?php if ($settings['slider_type'] == 'slider') { echo $this->get_render_attribute_string('slider'); } ?>>

      <?php


      if ($wp_query->have_posts()) {
         while ($wp_query->have_posts()) {
            $wp_query->the_post();
            if ($settings['post_view_type'] === 'upcoming' && !get_field('key_upcoming', get_the_ID())) {
               continue;
            }

            $video_run_time = get_post_meta(get_the_ID(), '_video_run_time');
            $video_url_link = get_post_meta(get_the_ID(), '_video_url_link');
            $video_choice = get_post_meta(get_the_ID(), '_video_choice');

            $run_time = '';
            $url_link = '';
            $censor_rating = '';
            if (isset($video_run_time[0])) {
               $run_time = $video_run_time[0];
            }
            if (isset($video_censor_rating[0])) {
               $censor_rating = $video_censor_rating[0];
            }

            if (isset($video_choice[0])) {
               if ($video_choice[0] == 'video_url') {
                  $url_link = $video_url_link[0];
               } else {
                  $url_link = get_the_permalink();
               }
            }

      ?>
            <?php
            $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "medium_large");

            if ($settings['slider_type'] == 'grid') {
               if ($settings['video_grid_style'] == '1') {
                  $col = 'col-lg-12 col-md-4 col-sm-6 wl-child';
                  $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
               }
               if ($settings['video_grid_style'] == '2') {
                  $col = 'col-lg-6 col-md-4 col-sm-6 wl-child';
                  $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "large");
               }
               if ($settings['video_grid_style'] == '3') {
                  $col = 'col-lg-4 col-md-4 col-sm-6 wl-child';
                  $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "medium_large");
               }
               if ($settings['video_grid_style'] == '4') {
                  $col = 'col-lg-3 col-md-4 col-sm-6 wl-child';
                  $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "medium_large");
               }
            ?>
               <li class="slide-item <?php echo esc_attr($col); ?>">
                  <style>
                     @media (min-width: 1920px) {
                        <?php
                        $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
                        ?>
                     }
                  </style>
                  <div class="block-images position-relative watchlist-img">
                     <div class="img-box">
                        <img src="<?php echo esc_url($full_image[0]) ?>" class="img-fluid" alt="streamit">
                     </div>
                     <div class="block-description">
                        <h6 class="iq-title">
                           <a href="<?php echo get_the_permalink(); ?>">
                              <?php the_title(); ?>
                           </a>
                        </h6>
                        <div class="video-time d-flex align-items-center my-2">
                           <div class="badge badge-secondary p-1 mr-2"><?php echo esc_html($censor_rating, "streamit-extensions"); ?></div>
                           <span class="text-white"><?php echo esc_html($run_time, "streamit-extensions"); ?></span>
                        </div>
                        <div class="hover-buttons">

                           <a href="<?php echo get_the_permalink(); ?>" class="btn btn-hover iq-button">
                              <i class="fa fa-play mr-1" aria-hidden="true"></i>

                              <?php echo esc_html($settings['play_now_text'], "streamit-extensions"); ?>
                           </a>

                        </div>
                     </div>
                     <div class="block-social-info">
                        <ul class="list-inline p-0 m-0 music-play-lists">
                           <?php if (isset($iq_option['streamit_display_social_icons'])) {
                              if ($iq_option['streamit_display_social_icons'] == 'yes') {
                           ?>
                                 <li class="share">
                                    <span><i class="ri-share-fill"></i></span>
                                    <div class="share-box">
                                       <div class="d-flex align-items-center">
                                          <a href="https://www.facebook.com/sharer?u=<?php echo get_the_permalink(); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="ri-facebook-fill"></i></a>
                                          <a href="http://twitter.com/intent/tweet?text=<?php the_title(); ?>&url=<?php echo get_the_permalink(); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="ri-twitter-fill"></i></a>
                                          <a href="#" data-link='<?php the_permalink(); ?>' class="share-ico iq-copy-link"><i class="ri-links-fill"></i></a>
                                       </div>
                                    </div>
                                 </li>
                           <?php }
                           } ?>
                           <?php if (isset($iq_option['streamit_display_like'])) {
                              if ($iq_option['streamit_display_like'] == 'yes') {
                           ?>
                                 <li>
                                    <div class="iq-like-btn"><?php echo do_shortcode('[wp_ulike for="video" id="' . get_the_ID() . '" style="wpulike-heart"]'); ?></div>
                                 </li>
                           <?php }
                           } ?>
                           <li>
                              <?php
                              if (!is_user_logged_in()) {
                                 if (isset($iq_option['streamit_signin_link'])) {
                                    $iqonic_signin_link = get_page_link($iq_option['streamit_signin_link']);

                              ?>
                                    <a class="watch-list-not" href="<?php echo esc_url($iqonic_signin_link) ?>">
                                       <span><i class="ri-add-line"></i></span>
                                    </a>
                                 <?php }
                              } else {
                                 ?>
                                 <a class="watch-list" rel="<?php echo get_the_ID(); ?>">
                                    <?php
                                    echo add_to_watchlist(get_the_ID());
                                    ?>
                                 </a>
                              <?php } ?>
                           </li>

                        </ul>
                     </div>
                  </div>
               </li>

            <?php } else { ?>

               <li class="slide-item">
                  <style>
                     @media (min-width: 1920px) {
                        <?php
                        $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
                        ?>
                     }
                  </style>
                  <div class="block-images position-relative">
                     <div class="img-box">
                        <img src="<?php echo esc_url($full_image[0]) ?>" class="img-fluid" alt="streamit">
                     </div>
                     <div class="block-description">
                        <h6 class="iq-title">
                           <a href="<?php echo  get_the_permalink(); ?>">
                              <?php the_title(); ?>
                           </a>
                        </h6>
                        <div class="video-time d-flex align-items-center my-2">
                           <div class="badge badge-secondary p-1 mr-2"><?php echo esc_html($censor_rating, "streamit-extensions"); ?></div>
                           <span class="text-white"><?php echo esc_html($run_time, "streamit-extensions"); ?></span>
                        </div>
                        <div class="hover-buttons">

                           <a href="<?php echo  get_the_permalink(); ?>" class="btn btn-hover iq-button">
                              <i class="fa fa-play mr-1" aria-hidden="true"></i>

                              <?php echo esc_html($settings['play_now_text'], "streamit-extensions"); ?>
                           </a>

                        </div>
                     </div>
                     <div class="block-social-info">
                        <ul class="list-inline p-0 m-0 music-play-lists">
                           <?php if (isset($iq_option['streamit_display_social_icons'])) {
                              if ($iq_option['streamit_display_social_icons'] == 'yes') {
                           ?>
                                 <li class="share">
                                    <span><i class="ri-share-fill"></i></span>
                                    <div class="share-box">
                                       <div class="d-flex align-items-center">
                                          <a href="https://www.facebook.com/sharer?u=<?php echo  get_the_permalink(); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="ri-facebook-fill"></i></a>
                                          <a href="http://twitter.com/intent/tweet?text=<?php the_title(); ?>&url=<?php echo get_the_permalink(); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="ri-twitter-fill"></i></a>
                                          <a href="#" data-link='<?php the_permalink(); ?>' class="share-ico iq-copy-link"><i class="ri-links-fill"></i></a>
                                       </div>
                                    </div>
                                 </li>
                           <?php }
                           } ?>
                           <?php if (isset($iq_option['streamit_display_like'])) {
                              if ($iq_option['streamit_display_like'] == 'yes') {
                           ?>
                                 <li>
                                    <div class="iq-like-btn"><?php echo do_shortcode('[wp_ulike for="video" id="' . get_the_ID() . '" style="wpulike-heart"]'); ?></div>
                                 </li>
                           <?php }
                           } ?>
                           <li>
                              <?php
                              if (!is_user_logged_in()) {
                                 if (isset($iq_option['streamit_signin_link'])) {
                                    $iqonic_signin_link = get_page_link($iq_option['streamit_signin_link']);

                              ?>
                                    <a class="watch-list-not" href="<?php echo esc_url($iqonic_signin_link) ?>">
                                       <span><i class="ri-add-line"></i></span>
                                    </a>
                                 <?php }
                              } else {
                                 ?>
                                 <a class="watch-list" rel="<?php echo get_the_ID(); ?>">
                                    <?php
                                    echo add_to_watchlist(get_the_ID());
                                    ?>
                                 </a>
                              <?php } ?>
                           </li>

                        </ul>
                     </div>
                  </div>
               </li>
            <?php } ?>
      <?php }



         wp_reset_postdata();
      } ?>
   </ul>
   <?php
   $tot = $wp_query->found_posts;


   if ($settings['slider_type'] == 'grid' && $settings['pagination'] == 'yes') {
      $total_pages = $wp_query->max_num_pages;

      if ($total_pages > 1) {
         /** PAGINATION */
         $big = 999999999; // need an unlikely integer

         $pagination_args = array(
            'base' => str_replace($big, '%#%', get_pagenum_link($big)),
            'format' => '?paged=%#%',
            'current' => max(1, get_query_var('paged')),
            'total' => $total_pages,
            'prev_next'       => True,
            'prev_text'       => '<span aria-hidden="true">' . esc_html__('Previous page', 'streamit-extensions') . '</span>',
            'next_text'       => '<span aria-hidden="true">' . esc_html__('Next page', 'streamit-extensions') . '</span>',
            'type'            => 'list',
            'add_args'        => false,
            'add_fragment'    => ''
         );
         $paginate_links = paginate_links($pagination_args);
         if ($paginate_links) {
            echo '<div class="col-lg-12 col-md-12 col-sm-12">
                     <div class="pagination justify-content-center">
                                 <nav aria-label="Page navigation">';
            printf(esc_html__('%s', 'streamit-extension'), $paginate_links);
            echo '</nav>
                         </div>
                     </div>';
         }
      }
   }
   if ($settings['slider_type'] == 'grid' && $settings['pagination'] == 'loadmore') {
      if ($wp_query->max_num_pages > 1) {
         echo '<a class="streamit_loadmore_btn_' . $this->get_id() . ' btn btn-hover iq-button" tabindex="0" data-loading-text="' . $settings['loading_text'] . '">
                            <span>' . $settings['more_text'] . '</span>
                        </a>';
      }
   }
   if ($settings['slider_type'] == 'grid' && $settings['pagination'] == 'infinite') {
      if ($wp_query->max_num_pages > 1) {
         echo '<div class="loader-wheel-container">                                                                   
         </div>';
      }
   }
   ?>
</div>
<?php if ($settings['slider_type'] == 'grid' && $settings['pagination'] == 'loadmore') { ?>
   <script>
      jQuery('.streamit_loadmore_btn_<?php echo $this->get_id() ?>').click(function() {
         let button = jQuery(this);
         let button_load = jQuery(this).attr('data-loading-text');
         let button_text = jQuery(this).text();
         let parentList = button.parent().find('.video-list-grid');


         let data = {
            'action': 'loadmore_video',
            'query': streamit_loadmore_params.posts, // that's how we get params from wp_localize_script() function
            'page': streamit_loadmore_params.current_page,
            'setting': <?php echo json_encode($this->get_settings()); ?>
         };

         jQuery.ajax({ // you can also use jQuery.post here
            url: streamit_loadmore_params.ajaxurl, // AJAX handler
            data: data,
            type: 'POST',
            beforeSend: function(xhr) {
               button.text(button_load); // change the button text, you can also add a preloader image
            },
            success: function(data) {
               if (data) {
                  button.text(button_text)
                  parentList.append(data); // insert new posts
                  streamit_loadmore_params.current_page++;

                  if (streamit_loadmore_params.current_page == streamit_loadmore_params.max_page) {
                     button.remove(); // if last page, remove the button
                  }

               } else {
                  button.remove(); // if no data, remove the button as well
               }
            }
         });
      });
   </script>
<?php } ?>
<?php if ($settings['slider_type'] == 'grid' && $settings['pagination'] == 'infinite') { ?>
   <script>
      jQuery(function(jQuery) {
         var canBeLoaded = true,
            bottomOffset = 2000; // the distance (in px) from the page bottom when you want to load more posts

         var streamit_options = jQuery('.streamit_datapass_video').data('options');


         if (streamit_options == "infinite") {


            jQuery(window).scroll(function() {
               let button = jQuery(this);
               let parentList = button.parent().find('.video-list-grid');

               //** search load more *//
               let data = {
                  'action': 'loadmore_video',
                  'query': streamit_loadmore_params.posts, // that's how we get params from wp_localize_script() function
                  'page': streamit_loadmore_params.current_page,
                  'setting': <?php echo json_encode($this->get_settings()); ?>
               };

               if (jQuery(document).scrollTop() > (jQuery(document).height() - bottomOffset) && canBeLoaded == true) {

                  jQuery.ajax({
                     url: streamit_loadmore_params.ajaxurl,
                     data: data,
                     type: 'POST',
                     beforeSend: function(xhr) {
                        canBeLoaded = false;
                     },
                     success: function(data) {
                        if (data) {
                           jQuery(".loader-wheel-container").html('<div class="loader-wheel"><i><i><i><i><i><i><i><i><i><i><i><i></i></i></i></i></i></i></i></i></i></i></i></i></div>');
                           jQuery('.favorites-contens').find('.video-list-grid').append(data); // where to insert posts
                           canBeLoaded = true; // the ajax is completed, now we can run it again
                           streamit_loadmore_params.current_page++;
                        } else {
                           jQuery(".loader-wheel-container").html('');
                        }

                     }
                  });
               }


            });

         } else {
            //nothing to call
         }
      });
   </script>
<?php } ?>