<?php

namespace Elementor;

$html = '';
if (!defined('ABSPATH')) exit;

$settings = $this->get_settings();
$args = array();
$tax_query = array();
$id_int = rand(10, 100);
$taxargs = array();

$args = array(
    'post_status'       => 'publish',
);
if ($settings['iq_type'] === 'video') {
    $args['post_type'] = 'video';
} else if ($settings['iq_type'] === 'tv_show') {
    $args['post_type'] = 'tv_show';
} else {
    $args['post_type'] = 'movie';
}

if (!empty($settings['iq_movie_genre']) && $settings['iq_type'] === 'movie') {
    $tax_query['taxonomy'] = 'movie_genre';
    $tax_query['field'] = 'slug';
    $tax_query['terms'] = $settings['iq_movie_genre'];
    $tax_query['operator'] = 'IN';
    array_push($taxargs, $tax_query);
}

if (!empty($settings['iq_movie_tag']) && $settings['iq_type'] === 'movie') {
    $tax_query['taxonomy'] = 'movie_tag';
    $tax_query['field'] = 'slug';
    $tax_query['terms'] = $settings['iq_movie_tag'];
    $tax_query['operator'] = 'IN';
    array_push($taxargs, $tax_query);
}

if (!empty($settings['iq_tv_show_genre']) && $settings['iq_type'] === 'tv_show') {
    $tax_query['taxonomy'] = 'tv_show_genre';
    $tax_query['field'] = 'slug';
    $tax_query['terms'] = $settings['iq_tv_show_genre'];
    $tax_query['operator'] = 'IN';
    array_push($taxargs, $tax_query);
}

if (!empty($settings['iq_tv_show_tag']) && $settings['iq_type'] === 'tv_show') {
    $tax_query['taxonomy'] = 'tv_show_tag';
    $tax_query['field'] = 'slug';
    $tax_query['terms'] = $settings['iq_tv_show_tag'];
    $tax_query['operator'] = 'IN';
    array_push($taxargs, $tax_query);
}

if (!empty($settings['iq_video_genre']) && $settings['iq_type'] === 'video') {
    $tax_query['taxonomy'] = 'video_cat';
    $tax_query['field'] = 'slug';
    $tax_query['terms'] = $settings['iq_video_genre'];
    $tax_query['operator'] = 'IN';
    array_push($taxargs, $tax_query);
}

if (!empty($settings['iq_video_tag']) && $settings['iq_type'] === 'video') {
    $tax_query['taxonomy'] = 'video_tag';
    $tax_query['field'] = 'slug';
    $tax_query['terms'] = $settings['iq_video_tag'];
    $tax_query['operator'] = 'IN';
    array_push($taxargs, $tax_query);
}

if (!empty($tax_query)) {
    $args['tax_query'] = $taxargs;
    $args['tax_query']['relation'] = 'OR';
}
$wp_query = new \WP_Query($args);
$nav_slider = '';
$slider = '';
if ($wp_query->have_posts()) {
    while ($wp_query->have_posts()) {
        $wp_query->the_post();
        $back_img = get_field('movie_back_image', get_the_ID());
        $movie_logo = get_field('name_logo', get_the_ID());
        $trailer_link = get_field('name_trailer_link', get_the_ID());
        $movie_run_time = get_post_meta(get_the_ID(), '_movie_run_time');
        $movie_url_link = get_post_meta(get_the_ID(), '_movie_url_link');
        $video_run_time = get_post_meta(get_the_ID(), '_video_run_time');
        $movie_censor_rating = get_post_meta(get_the_ID(), '_movie_censor_rating');
        $movie_choice = get_post_meta(get_the_ID(), '_movie_choice');
        $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
        $display = '';

        $run_time = '';
        $censor_rating = '';
        if ($settings['iq_type'] === 'video') {
            if (isset($video_run_time[0])) {
                $run_time = $video_run_time[0];
            }

            if (function_exists('set_post_view')) {
                if (get_post_view() == 0) {
                    $censor_rating = '<i class="fa fa-eye"></i> ' . esc_html('0 Views');
                } else {
                    $censor_rating = '<i class="fa fa-eye"></i> ' . get_post_view();
                };
            }
        } else if ($settings['iq_type'] === 'tv_show') {
            $meta = get_post_meta(get_the_ID());
            $season_data = unserialize($meta['_seasons'][0]);

            if (isset($season_data)) {
                if (is_array($season_data)) {
                    $censor_rating = count($season_data) . ' Seasons';
                } else {
                    $censor_rating = '1 Seasons';
                }
            }
            $run_time = get_the_date('M Y');
        } else {
            if (isset($movie_run_time[0])) {
                $run_time = $movie_run_time[0];
            }

            if (isset($movie_censor_rating[0])) {
                $censor_rating = $movie_censor_rating[0];
            }
        }


        $nav_slider .= '
            <li class="slick-bg">
                <a href="" class="iq-top-verticle-slider">
                    <img src="' . esc_url($full_image[0]) . '" class="img-fluid w-100" alt="">
                </a>
                <div class="responsive-verticle-slider">
                    <a href="' . get_the_permalink() . '">
                    <img src="' . esc_url($full_image[0]) . '" class="img-fluid w-100" alt="">
                    </a>
                    <div class="block-description">
                    <h5 class="iq-verticle-title">' . get_the_title() . '</h5>
                    <div class="movie-time d-flex align-items-center my-2">
                        <div class="badge badge-secondary p-1 mr-2">' . $censor_rating . '</div>
                        <span class="text-white">' . $run_time . '</span>
                    </div>
                    <div class="hover-buttons mt-2">
                        <a href="' . get_the_permalink() . '" class="btn btn-hover iq-button" tabindex="0"><i class="fa fa-play mr-2" aria-hidden="true"></i>
                         <span>' . esc_html($settings['play_now_text'], "streamit-extensions") . '</span>
                        </a>
                    </div>
                </div>
            </div>
            </li>';
        $slider .= '
            <li>
                    <div class="block-images position-relative">
                    <a href="' . get_the_permalink() . '">
                    <img src="' . esc_url($full_image[0]) . '" class="img-fluid w-100" alt="">
                    </a>
                    <div class="block-description">
                        <h5 class="iq-verticle-title">' . get_the_title() . '</h5>
                        <div class="movie-time d-flex align-items-center my-2">
                            <div class="badge badge-secondary p-1 mr-2">' . $censor_rating . '</div>
                            <span class="text-white">' . $run_time . '</span>
                        </div>
                        <div class="hover-buttons">
                            <a href="' . get_the_permalink() . '" class="btn btn-hover iq-button" tabindex="0">
                            <i class="fa fa-play mr-1" aria-hidden="true"></i><span>' . esc_html($settings['play_now_text'], "streamit-extensions") . '</span>
                            </a>
                        </div>
                    </div>
                    </div>
                </li>
            ';
    }
    wp_reset_postdata();
}
?>
<div id="iq-topten" class="position-relative iq-rtl-direction iq-topten">
    <h4 class="iq-title"><?php echo __($settings['movie_section_title'], "streamit-extensions"); ?></h4>
    <div class="topten-contens">
        <ul id="<?php echo esc_attr('top-ten-slider-' . $id_int); ?>" data-rand="<?php echo esc_attr('top-ten-slider-' . $id_int); ?>" class="top-ten-slider list-inline p-0 m-0  d-flex align-items-center">
            <?php echo $nav_slider; ?>
        </ul>
        <div class="vertical_s">
            <ul id="<?php echo esc_attr('top-ten-slider-nav-' . $id_int); ?>" data-rand="<?php echo esc_attr('top-ten-slider-nav-' . $id_int); ?>" class="top-ten-slider-nav list-inline p-0 m-0  d-flex align-items-center">
                <?php echo $slider; ?>
            </ul>
        </div>
    </div>
</div>