/*
Template: Streamit - Responsive Bootstrap 4 Template
Author: iqonicthemes.in
Design and Developed by: iqonicthemes.in
NOTE: This file contains the styling for responsive Template.
*/

/*----------------------------------------------
Index Of Script
------------------------------------------------

:: Sticky Header Animation & Height
:: Back to Top
:: Header Menu Dropdown
:: Slick Slider
:: Owl Carousel
:: Page Loader
:: Mobile Menu Overlay
:: Equal Height of Tab Pane
:: Active Class for Pricing Table
:: Select 2 Dropdown
:: Video Popup
:: Flatpicker
:: Custom File Uploader

------------------------------------------------
Index Of Script
----------------------------------------------*/

(function (jQuery) {
	"use strict";
	jQuery(document).ready(function () {

		window.onscroll = function () {
			jQuery(document).find('.nav-link[aria-selected="true"]').addClass("active");
		};

		/*---------------------------------------------------------------------
			Slick Slider
		----------------------------------------------------------------------- */
		if (jQuery('.iq-home-banner-slider').length > 0) {
			let homebannerSlider = jQuery('.iq-home-banner-slider');
			homebannerSlider.each(function () {
				let homeslider = '#' + jQuery(this).find('.home-slider').attr('data-rand');
				let jQuerySlider = jQuery(this).find('.home-slider');
				jQuery(homeslider).slick({
					cssEase: 'ease-in-out',
					lazyLoad: 'progressive',
					dots: false,
					arrows: jQuerySlider.data("nav"),
					infinite: false,
					speed: jQuerySlider.data("speed"),
					autoplay: jQuerySlider.data("autoplay"),
					prevArrow: '<div class="slick-nav prev-arrow"><i></i><svg><use xlink:href="#circle"></svg></div>',
					nextArrow: '<div class="slick-nav next-arrow"><i></i><svg><use xlink:href="#circle"></svg></div>',
					responsive: [
						{
							breakpoint: 1024,
							settings: {
								dots: true,
								arrows: false,
							}
						}
					]
				}).slickAnimation();
				jQuery('.slick-nav').on('click touch', function (e) {

					e.preventDefault();

					let arrow = jQuery(this);

					if (!arrow.hasClass('animate')) {
						arrow.addClass('animate');
						setTimeout(() => {
							arrow.removeClass('animate');
						}, 1600);
					}

				});
			});
		}
		jQuery('.favorites-slider').each(function () {
			var jQuerySlider = jQuery(this);
			jQuerySlider.slick({
				dots: false,
				arrows: jQuerySlider.data("nav"),
				infinite: false,
				speed: jQuerySlider.data("speed"),
				autoplay: jQuerySlider.data("autoplay"),
				slidesToShow: jQuerySlider.data("items"),
				nextArrow: '<a href="#" class="slick-arrow slick-next"><i class= "fa fa-chevron-right"></i></a>',
				prevArrow: '<a href="#" class="slick-arrow slick-prev"><i class= "fa fa-chevron-left"></i></a>',
				responsive: [
					{
						breakpoint: 1200,
						settings: {
							slidesToShow: jQuerySlider.data("items-laptop"),
							infinite: true,
							dots: false
						}
					},
					{
						breakpoint: 768,
						settings: {
							slidesToShow: jQuerySlider.data("items-tab")
						}
					},
					{
						breakpoint: 480,
						settings: {
							slidesToShow: jQuerySlider.data("items-mobile")
						}
					}
				]
			});
		});
		if (jQuery('.iq-topten').length > 0) {
			let toptenSlider = jQuery('.iq-topten');
			toptenSlider.each(function () {
				let top_ten_slider = '#' + jQuery(this).find('.top-ten-slider').attr('data-rand');
				let top_ten_slider_nav = '#' + jQuery(this).find('.top-ten-slider-nav').attr('data-rand');

				jQuery(top_ten_slider).slick({
					slidesToShow: 1,
					arrows: false,
					fade: true,
					asNavFor: top_ten_slider_nav,
					responsive: [
						{
							breakpoint: 992,
							settings: {
								asNavFor: false,
								arrows: true,
								nextArrow: '<button class="NextArrow"><i class="ri-arrow-right-s-line"></i></button>',
								prevArrow: '<button class="PreArrow"><i class="ri-arrow-left-s-line"></i></button>',
							}
						}
					]
				});
				jQuery(top_ten_slider_nav).slick({
					slidesToShow: 3,
					asNavFor: top_ten_slider,
					dots: false,
					arrows: true,
					infinite: true,
					vertical: true,
					verticalSwiping: true,
					centerMode: false,
					nextArrow: '<button class="NextArrow"><i class="ri-arrow-down-s-line"></i></button>',
					prevArrow: '<button class="PreArrow"><i class="ri-arrow-up-s-line"></i></button>',
					focusOnSelect: true,
					responsive: [
						{
							breakpoint: 1200,
							settings: {
								slidesToShow: 2,
							}
						},
						{
							breakpoint: 600,
							settings: {
								asNavFor: false,
							}
						},
					]
				});
			});
		}

		if (jQuery('.iq-trending-tabs').length > 0) {
			let tabSlider = jQuery('.iq-trending-tabs');
			tabSlider.each(function () {
				let trendingSlider = '#' + jQuery(this).find('.trending-slider').attr('data-rand');
				let trendingSliderNav = '#' + jQuery(this).find('.trending-slider-nav').attr('data-rand');
				jQuery(trendingSlider).slick({
					slidesToShow: 1,
					slidesToScroll: 1,
					arrows: true,
					fade: true,
					draggable: false,
					swipe: false,
					touchMove: false,
					asNavFor: trendingSliderNav,
					nextArrow: '<a href="#" class="slick-arrow slick-next"><i class= "fa fa-chevron-right"></i></a>',
					prevArrow: '<a href="#" class="slick-arrow slick-prev"><i class= "fa fa-chevron-left"></i></a>',
				});
				jQuery(trendingSliderNav).slick({
					slidesToShow: 5,
					slidesToScroll: 1,
					asNavFor: trendingSlider,
					dots: false,
					arrows: false,
					infinite: true,
					centerMode: true,
					centerPadding: 0,
					focusOnSelect: true,
					responsive: [
						{
							breakpoint: 1024,
							settings: {
								slidesToShow: 3,
								slidesToScroll: 1,
							}
						},
						{
							breakpoint: 600,
							settings: {
								slidesToShow: 2,
								slidesToScroll: 1
							}
						},
						{
							breakpoint: 400,
							settings: {
								slidesToShow: 1,
								slidesToScroll: 1
							}
						}
					]
				});
			});
		}
		if (jQuery('.iq-tvshows-slider').length > 0) {
			let tvshowsliders = jQuery('.iq-tvshows-slider');
			tvshowsliders.each(function () {

				let tvshowsslider = '#' + jQuery(this).find('.tvshows-slider').attr('data-rand');
				let jQuerySlider = jQuery(this).find('.tvshows-slider');
				jQuery(tvshowsslider).slick({
					centerMode: true,
					centerPadding: '200px',
					cssEase: 'ease-in-out',
					speed: jQuerySlider.data("speed"),
					slidesToShow: 1,
					nextArrow: '<button class="NextArrow"><i class="ri-arrow-right-s-line"></i></button>',
					prevArrow: '<button class="PreArrow"><i class="ri-arrow-left-s-line"></i></button>',
					dots: false,
					arrows: jQuerySlider.data("nav"),
					autoplay: jQuerySlider.data("autoplay"),
					slidesToScroll: 1,
					autoplaySpeed: jQuerySlider.data("speed"),
					responsive: [
						{
							breakpoint: 1200,
							settings: {
								arrows: false,
								centerMode: true,
								centerPadding: '50px',
								slidesToShow: 1
							}
						},
						{
							breakpoint: 991,
							settings: {
								arrows: false,
								centerMode: true,
								centerPadding: '20px',
								slidesToShow: 1
							}
						},
						{
							breakpoint: 480,
							settings: {
								arrows: false,
								centerMode: true,
								centerPadding: '20px',
								slidesToShow: 1
							}
						}
					]
				});
			});
		}
		jQuery('.season-select').on('change', function () {
			jQuery('.owl-carousel , .single-season-data').each(function () {
				jQuery(this).removeClass('active show');
			});
			jQuery('[data-display=' + jQuery(this).val() + ']').addClass('active show');
		});

		/*---------------------------------------------------------------------
			Owl Carousel
		----------------------------------------------------------------------- */
		jQuery('.owl-carousel').owlCarousel({
			loop: true,
			margin: 20,
			nav: true,
			navText: ["<i class='ri-arrow-left-s-line'></i>", "<i class='ri-arrow-right-s-line'></i>"],
			dots: false,
			responsive: {
				0: {
					items: 1
				},
				500: {
					items: 2
				},
				1000: {
					items: 4
				}
			}
		});

		/*---------------------------------------------------------------------
			Page Loader
		----------------------------------------------------------------------- */
		jQuery("#load").fadeOut();
		jQuery("#loading").delay(0).fadeOut("slow");

		jQuery('.widget .fa.fa-angle-down, #main .fa.fa-angle-down').on('click', function () {
			jQuery(this).next('.children, .sub-menu').slideToggle();
		});


		/*---------------------------------------------------------------------
				Active Class for Pricing Table
		   -----------------------------------------------------------------------*/
		if (jQuery('.iq-pricing-card #my-table').length > 0) {
			let activePlan = jQuery('.iq-pricing-card #my-table').data('active');
			jQuery('.iq-pricing-card #my-table tr .' + activePlan).children().addClass('active');
			let col = jQuery('.iq-pricing-card #my-table tr .' + activePlan).index();
			jQuery(".iq-pricing-card #my-table tr td:nth-child(" + parseInt(col + 1) + ")").addClass('active');
		}
		let actWrap = '.iq-pricing-card-two .iq-price-rate-wrap';
		if (jQuery(actWrap).length > 0) {
			let planIdOnLoad = jQuery(actWrap + '.active').data('paid-id');
			let planLink = jQuery('.iq-pricing-card-two .iq-button').attr('href');
			jQuery('.iq-pricing-card-two .iq-button').attr('href', planLink + '?subscription_plan=' + planIdOnLoad);
			jQuery(document).on('click', actWrap, function () {
				jQuery(actWrap).removeClass('active');
				let planId = jQuery(this).data('paid-id');
				jQuery('.iq-pricing-card-two .iq-button').attr('href', planLink + '?subscription_plan=' + planId);
				jQuery(this).addClass('active');
			})

		}
		jQuery(".iq-pricing-card #my-table tr th").on("click", function () {
			jQuery('.iq-pricing-card #my-table tr th').children().removeClass('active');
			jQuery(this).children().addClass('active');
			jQuery(".iq-pricing-card #my-table td").each(function () {
				if (jQuery(this).hasClass('active')) {
					jQuery(this).removeClass('active')
				}
			});
			let col = jQuery(this).index();
			jQuery(".iq-pricing-card #my-table tr td:nth-child(" + parseInt(col + 1) + ")").addClass('active');
		});

		//copy link
		jQuery('.iq-copy-link').on('click', function () {
			let link = jQuery(this).data('link');
			document.addEventListener('copy', function (e) {
				e.clipboardData.setData('text/plain', link);
				e.preventDefault();
			}, true);
			if (document.execCommand('copy')) {
				alert('copied');
			}
		});

		if (jQuery('.iq-login-form').length > 0) {
			let uname = jQuery('.iq-login-form #user_login');
			let pass = jQuery('.iq-login-form #user_pass');
			let email = jQuery('.iq-login-form #user-email');
			uname.attr('placeholder', 'Username / Email Address');
			pass.attr('placeholder', 'Password');
			email.attr('placeholder', 'Email Address');
		}


		jQuery(".custom-file-input").on("change", function () {

			let fileName = jQuery(this).val().split("\\").pop();
			jQuery(this).siblings(".custom-file-label").addClass("selected").html(fileName);
		});
		jQuery(window).resize(function () {

		});
		if (jQuery('.wl-child').length) {
			let count;
			let in_count;
			let width = jQuery(window).width();
			if (width > 991) {
				count = 3; in_count = 4;
			}
			else if (width > 767 && width < 991) {
				count = 2; in_count = 3;
			}
			else if (width < 768) {
				count = 1; in_count = 2;
			}
			else {
				count = 3;
				in_count = 4;
			}
			let k = 0;
			let j = count;
			let len = jQuery('.wl-child').length;

			jQuery('.wl-child').each(function () {
				if (k === 0) {
					jQuery(this).find('.watchlist-img').addClass('watchlist-first');
				}
				if (j == k || k === count || (len.length - 1) === k) {
					j += in_count;
					jQuery(this).find('.watchlist-img').addClass('watchlist-last');
					jQuery(this).next().find('.watchlist-img').addClass('watchlist-first');
				}
				k++;
			})
		}

		//Paid membership plugin input button override
		if (jQuery('#pms_register-form [name=pms_register]').length > 0) {
			let pmsRegisterText = jQuery('#pms_register-form [name=pms_register]').val();
			jQuery('#pms_register-form [name=pms_register]').after('<button name="pms_register" type="submit" class="btn btn-hover iq-button" value="' + pmsRegisterText + '">' + pmsRegisterText + '</button>');
			jQuery('#pms_register-form [name=pms_register]:first').remove();
		}
		if (jQuery('#pms_login [name=wp-submit]').length > 0) {
			let pmsLoginText = jQuery('#pms_login [name=wp-submit]').val();
			jQuery('#pms_login [name=wp-submit]').after('<button type="submit" name="wp-submit" id="wp-submit" class="btn btn-hover iq-button" value="' + pmsLoginText + '">' + pmsLoginText + '</button>');
			jQuery('#pms_login [name=wp-submit]:first').remove();
		}
		if (jQuery('#pms-upgrade-subscription-form [name=pms_upgrade_subscription]').length > 0) {
			let pmsUpgradeText = jQuery('#pms-upgrade-subscription-form [name=pms_upgrade_subscription]').val();
			jQuery('#pms-upgrade-subscription-form [name=pms_upgrade_subscription]').after('<button type="submit" name="pms_upgrade_subscription" class="btn btn-hover iq-button mr-3" value="' + pmsUpgradeText + '">' + pmsUpgradeText + '</button>');
			jQuery('#pms-upgrade-subscription-form [name=pms_upgrade_subscription]:first').remove();
		}
		if (jQuery('#pms-upgrade-subscription-form [name=pms_redirect_back]').length > 0) {
			let pmsBackText = jQuery('#pms-upgrade-subscription-form [name=pms_redirect_back]').val();
			jQuery('#pms-upgrade-subscription-form [name=pms_redirect_back]').after('<button type="submit" name="pms_redirect_back" class="btn btn-hover iq-button" value="' + pmsBackText + '">' + pmsBackText + '</button>');
			jQuery('#pms-upgrade-subscription-form [name=pms_redirect_back]:first').remove();
		}
		if (jQuery('#pms_edit-profile-form [name=pms_edit_profile]').length > 0) {
			let pmsEditText = jQuery('#pms_edit-profile-form [name=pms_edit_profile]').val();
			jQuery('#pms_edit-profile-form [name=pms_edit_profile]').after('<button name="pms_edit_profile" type="submit" class="btn btn-hover iq-button" value="' + pmsEditText + '">' + pmsEditText + '</button>');
			jQuery('#pms_edit-profile-form [name=pms_edit_profile]:first').remove();
		}
		if (jQuery('#pms_recover_password_form [name=submit]').length > 0) {
			let pmsRecoverText = jQuery('#pms_recover_password_form [name=submit]').val();
			jQuery('#pms_recover_password_form [name=submit]').after('<button type="submit" name="submit" class="btn btn-hover iq-button" value="' + pmsRecoverText + '">' + pmsRecoverText + '</button>');
			jQuery('#pms_recover_password_form [name=submit]:first').remove();
		}
		// user forms validation
		if (jQuery('.iq-login-form #loginform').length > 0) {
			let iqonicLoginText = jQuery('.iq-login-form #loginform #wp-submit').val();
			jQuery('.iq-login-form #loginform #wp-submit').remove();
			jQuery('.iq-login-form #loginform .login-submit').append('<button type="submit" name="wp-submit" id="wp-submit" class="btn btn-hover iq-button" value="' + iqonicLoginText + '">' + iqonicLoginText + '</button>');

			jQuery('.iq-login-form #loginform').submit(function () {
				jQuery('.iq-login-form .error-msg').hide();
				let user_id = jQuery.trim(jQuery("#user_login").val());
				let user_pass = jQuery.trim(jQuery("#user_pass").val());
				let error = '';

				//jQuery(".validate-form #comment").removeClass('iq-warning');
				if (user_id === "" || user_pass === "") {
					if (user_id === "") {
						//jQuery(".validate-form #comment").addClass('iq-warning');
						error = '1';
					}
					if (user_pass === "") {
						//jQuery(".validate-form #comment").addClass('iq-warning');
						error = '1';
					}
				}
				if (error !== '' && error === '1') {
					jQuery('.iq-login-form .error-msg').html('Require Empty Field.');
					jQuery('.iq-login-form .error-msg').slideDown();
					return false;
				}


			});
		}
		if (jQuery('.iq-login-form #changepass').length > 0) {
			jQuery('.iq-login-form #changepass').submit(function () {
				jQuery('.iq-login-form .error-msg').hide();
				let user_email = jQuery.trim(jQuery("#user_email").val());
				let error = '';

				//jQuery(".validate-form #comment").removeClass('iq-warning');
				if (user_email === "") {
					//jQuery(".validate-form #comment").addClass('iq-warning');
					error = '1';
				}
				if (error !== '' && error === '1') {
					jQuery('.iq-login-form .error-msg').html('Require Empty Field.');
					jQuery('.iq-login-form .error-msg').slideDown();
					return false;
				}


			});
		}

		if (jQuery('#update-avatar').length > 0) {
			jQuery(document).on('click', '#iq-edit-avatar-btn', function () {
				jQuery('#update-avatar').slideToggle();
			});

			jQuery(document).on('click', '#cancel-avatar-edit', function () {
				jQuery('#update-avatar').slideToggle();
			});
		}

		jQuery(".iq-register .pms-account-subscription-details-table").parents('.iq-register .elementor-shortcode').css("height", "unset");


	});
})(jQuery);

jQuery(document).ready(function ($) {

	/***************************************
		ajax like shot feature
	***************************************/
	$(".watch-list").stop().click(function () {

		let rel = $(this).attr("rel");
		let thisElement = $(this);
		$(".watch-list[rel=" + rel + "]").html('<span><i class="fa fa-circle-o-notch fa-spin" style="font-size:24px;line-height: 28px;"></i></span>').addClass("adding");

		//alert(rel)
		let data = {
			data: rel,
			action: 'watchlist_callback'
		}
		$.ajax({
			action: "watchlist_callback",
			type: "GET",
			dataType: "json",
			url: ajaxurl,

			data: data,
			success: function (data) {

				if (data.status === true) {
					$(".watch-list[rel=" + rel + "]").addClass("adding");
					$(".watch-list[rel=" + rel + "]").html('<span><i class="fa fa-check" aria-hidden="true"></i></span>').addClass("added");
					//alert();
				} else {
					$(".watch-list[rel=" + rel + "]").html('<span><i class="ri-add-line"></i></span>').removeClass("removed");
					//alert('1');
					console.log(thisElement);
					thisElement.closest('.wl-child').remove();
				}

			}
		});

	});
});
