<?php
if (!function_exists('iqonic_blog_time_link')) :
    /**
     * Gets a nicely formatted string for the published date.
     */
    function iqonic_blog_time_link()
    {
        $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
        $time_string = sprintf(
            $time_string,
            get_the_date(DATE_W3C),
            get_the_date(),
            get_the_modified_date(DATE_W3C),
            get_the_modified_date()
        );

        // Wrap the time string in a link, and preface it with 'Posted on'.
        return sprintf(
            /* translators: %s: post date */
            __('<span class="screen-reader-text">Posted on</span> %s', "streamit-extensions"),
            '<a href="' . esc_url(get_permalink()) . '" rel="bookmark">' . $time_string . '</a>'
        );
    }
endif;

// get custom post type
function iq_custom_post_data($post_type = '', $args = array(), $return = '')
{
    $array = array();
    global $post;
    $args = array(
        'post_type'         => $post_type,
        'post_status'       => 'publish',
        'posts_per_page' => -1
    );
    $wp_query = new \WP_Query($args);
    if ($wp_query->have_posts()) {

        while ($wp_query->have_posts()) {
            $wp_query->the_post();
            if ($return == 'id') {
                $array[get_the_ID()] = get_the_title();
            }
            if ($return == 'slug') {
                $array[$post->post_name] = get_the_title();
            }
        }
        return $array;
    } else {
        return $wp_query;
    }
}
// get custom post type most like
function iq_get_most_liked($post_type = '', $args = array(), $return = '')
{
    $liked = wp_ulike_get_most_liked_posts(10, array($post_type), 'post', 'all', 'like');
    if ($liked) {
        foreach ($liked as $post) {
            $most_liked_ids[] = $post->ID;
        }
        return $most_liked_ids;
    }
}

// get custom taxonomy
function iq_get_custom_texonomy($taxo = '')
{
    if (empty($taxo)) {
        return;
    }
    $show_count = 0; // 1 for yes, 0 for no
    $pad_counts = 0; // 1 for yes, 0 for no
    $hierarchical = 1; // 1 for yes, 0 for no
    $title = '';
    $empty = 0;
    $array = array();
    $args = array(
        'taxonomy' => $taxo,
        'show_count' => $show_count,
        'pad_counts' => $pad_counts,
        'hierarchical' => $hierarchical,
        'hide_empty' => false,
        'parent' => 0
    );
    $wp_object =  get_categories($args);

    if (!empty($wp_object)) {
        foreach ($wp_object as $val) {
            $array[$val->slug] = $val->name;
        }
    }

    return $array;
}

// get custom post pages
function iq_get_pages()
{
    $wp_object =  get_all_page_ids();
    if (!empty($wp_object)) {
        foreach ($wp_object as $val) {
            $array[$val] = get_the_title($val);
        }
    }
    return $array;
}

//user profile picture update
if (!function_exists('iq_get_attachment_id')) {
    function iq_get_attachment_id($img)
    {
        $userdata = wp_get_current_user();
        $profile_image = $img;
        $url = '';
        $type      =  $profile_image['type'];

        $extension = pathinfo($profile_image['name'], PATHINFO_EXTENSION);

        // Upload dir.
        $upload_dir  = wp_upload_dir();
        $upload_path = str_replace('/', DIRECTORY_SEPARATOR, $upload_dir['path']) . DIRECTORY_SEPARATOR;

        // Save the image in the uploads directory.

        $upload_file = move_uploaded_file($profile_image["tmp_name"], $upload_path . $profile_image["name"]);

        $attachment = array(
            'post_mime_type' => $extension,
            'post_title'     => preg_replace('/\.[^.]+$/', '', $profile_image["name"]),
            'post_content'   => '',
            'post_status'    => 'inherit',
            'guid'           => $upload_dir['url'] . '/' . $profile_image["name"]
        );

        $attach_id = wp_insert_attachment($attachment, $upload_dir['path'] . '/' . $profile_image["name"]);

        // Regenerate Thumbnail
        global $wpdb;
        $images = $wpdb->get_results("SELECT ID FROM $wpdb->posts WHERE post_type = 'attachment' AND post_mime_type LIKE 'image/%' AND ID ='$attach_id'");

        foreach ($images as $image) {
            $id = $image->ID;
            $fullsizepath = get_attached_file($id);

            if (false === $fullsizepath || !file_exists($fullsizepath))
                return;
        }
        $url = wp_get_attachment_url($attach_id);

        $update = update_user_meta($userdata->ID, 'streamit_profile_image', $url);

        if (!is_wp_error($update)) {
            $img = get_user_meta($userdata->ID, 'streamit_profile_image');
            $data['profile_image'] = $img[0];
        }
        return $url;
    }
}

if (!function_exists('iqonic_random_strings')) {
    function iqonic_random_strings($random = '')
    {

        // String of all alphanumeric character 
        $str_result = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz' . $random;

        // Shufle the $str_result and returns substring 
        // of specified length 
        return substr(str_shuffle($str_result), 0, 5);
    }
}

//* movie grid**//
add_action('wp_ajax_loadmore_movie', 'streamit_movie_loadmore_ajax_handler'); // wp_ajax_{action}
add_action('wp_ajax_nopriv_loadmore_movie', 'streamit_movie_loadmore_ajax_handler'); // wp_ajax_nopriv_{action}
if (!function_exists('streamit_movie_loadmore_ajax_handler')) {
    function streamit_movie_loadmore_ajax_handler()
    {
        $streamit_options = get_option('streamit_options');
        $args = array(
            'post_type'         => 'movie',
            'post_status'       => 'publish',
            'paged' => $_POST['page'] + 1,
            'posts_per_page' => $_POST['setting']['posts_per_page']['size'],

        );
        if (!empty($_POST['setting']['iq_select_movies'])) {
            $args['post__in'] = $_POST['setting']['iq_select_movies'];
        }
        if (empty($_POST['setting']['iq_select_movies']) && $_POST['setting']['post_view_type'] === 'most_liked') {
            $args['post__in'] = iq_get_most_liked('movie', array(), 'id');
            $args['orderby'] = 'post__in';
        }
        if (empty($_POST['setting']['iq_select_movies']) && $_POST['setting']['post_view_type'] === 'most_viewd') {
            $args['meta_key']          = 'post_views_count';
            $args['orderby']           = 'meta_value_num';
            $args['order']             = 'DESC';
        }
        if (!empty($_POST['setting']['iq_movie_genre'])) {
            $tax_query['taxonomy'] = 'movie_genre';
            $tax_query['field'] = 'slug';
            $tax_query['terms'] = $_POST['setting']['iq_movie_genre'];
            $tax_query['operator'] = 'IN';
            array_push($taxargs, $tax_query);
        }
        if (!empty($_POST['setting']['iq_movie_tag'])) {
            $tax_query['taxonomy'] = 'movie_tag';
            $tax_query['field'] = 'slug';
            $tax_query['terms'] = $_POST['setting']['iq_movie_tag'];
            $tax_query['operator'] = 'IN';
            array_push($taxargs, $tax_query);
        }

        if (!empty($_POST['setting']['post_view_type']) && $_POST['setting']['post_view_type'] !== 'none') {
            if ($_POST['setting']['post_view_type'] === 'latest') {
                $args['orderby'] = 'publish_date';
                $args['order'] = 'DESC';
            }
        }
        if (!empty($_POST['setting']['order'])  && $_POST['setting']['post_view_type'] === 'upcoming' || $_POST['setting']['post_view_type'] === 'none') {
            $args['order'] = $_POST['setting']['order'];
        }

        if (!empty($tax_query)) {
            $args['tax_query'] = $taxargs;
            $args['tax_query']['relation'] = 'OR';
        }
        query_posts($args);
        if (have_posts()) :

            // run the loop
            while (have_posts()) : the_post();


                $movie_run_time = get_post_meta(get_the_ID(), '_movie_run_time');
                $movie_url_link = get_post_meta(get_the_ID(), '_movie_url_link');
                $run_time = '';
                $url_link = '';
                $censor_rating = '';
                if (isset($movie_run_time[0])) {
                    $run_time = $movie_run_time[0];
                }
                if (isset($movie_censor_rating[0])) {
                    $censor_rating = $movie_censor_rating[0];
                }

                if (isset($movie_choice[0])) {
                    if ($movie_choice[0] == 'movie_url') {
                        $url_link = $movie_url_link[0];
                    } else {
                        $url_link = get_the_permalink();
                    }
                }
                if ($_POST['setting']['movie_grid_style'] == '1') {
                    $col = 'col-lg-12 col-md-4 col-sm-6 wl-child';
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
                }
                if ($_POST['setting']['movie_grid_style'] == '2') {
                    $col = 'col-lg-6 col-md-4 col-sm-6 wl-child';
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "large");
                }
                if ($_POST['setting']['movie_grid_style'] == '3') {
                    $col = 'col-lg-4 col-md-4 col-sm-6 wl-child';
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "medium_large");
                }
                if ($_POST['setting']['movie_grid_style'] == '4') {
                    $col = 'col-lg-3 col-md-4 col-sm-6 wl-child';
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "medium_large");
                }
?>
                <div class="slide-item <?php echo esc_attr($col); ?>">
                    <style>
                        @media (min-width: 1920px) {
                            <?php
                            $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
                            ?>
                        }
                    </style>
                    <div class="block-images position-relative watchlist-img">
                        <div class="img-box">
                            <img src="<?php echo esc_url($full_image[0]) ?>" class="img-fluid" alt="streamit">
                        </div>
                        <div class="block-description">
                            <h6 class="iq-title">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_title(); ?>
                                </a>
                            </h6>
                            <div class="movie-time d-flex align-items-center my-2">
                                <div class="badge badge-secondary p-1 mr-2"><?php echo esc_html($censor_rating, "streamit-extensions"); ?></div>
                                <span class="text-white"><?php echo esc_html($run_time, "streamit-extensions"); ?></span>
                            </div>
                            <div class="hover-buttons">

                                <a href="<?php echo the_permalink(); ?>" class="btn btn-hover iq-button">
                                    <i class="fa fa-play mr-1" aria-hidden="true"></i>

                                    <?php echo esc_html($_POST['setting']['play_now_text'], "streamit-extensions"); ?>
                                </a>

                            </div>
                        </div>
                        <div class="block-social-info">
                            <ul class="list-inline p-0 m-0 music-play-lists">
                                <?php if (isset($streamit_options['streamit_display_social_icons'])) {
                                    if ($streamit_options['streamit_display_social_icons'] == 'yes') {
                                ?>
                                        <li class="share">
                                            <span><i class="ri-share-fill"></i></span>
                                            <div class="share-box">
                                                <div class="d-flex align-items-center">
                                                    <a href="https://www.facebook.com/sharer?u=<?php the_permalink(); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="ri-facebook-fill"></i></a>
                                                    <a href="http://twitter.com/intent/tweet?text=<?php the_title(); ?>&url=<?php echo get_the_permalink(); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="ri-twitter-fill"></i></a>
                                                    <a href="#" data-link='<?php the_permalink(); ?>' class="share-ico iq-copy-link"><i class="ri-links-fill"></i></a>
                                                </div>
                                            </div>
                                        </li>
                                <?php }
                                } ?>
                                <?php if (isset($streamit_options['streamit_display_like'])) {
                                    if ($streamit_options['streamit_display_like'] == 'yes') {
                                ?>
                                        <li>
                                            <div class="iq-like-btn"><?php echo do_shortcode('[wp_ulike for="movie" id="' . get_the_ID() . '" style="wpulike-heart"]'); ?></div>
                                        </li>
                                <?php }
                                } ?>
                                <li>
                                    <?php
                                    if (!is_user_logged_in()) {
                                        if (isset($iq_option['streamit_signin_link'])) {
                                            $iqonic_signin_link = get_page_link($iq_option['streamit_signin_link']);

                                    ?>
                                            <a class="watch-list-not" href="<?php echo esc_url($iqonic_signin_link) ?>">
                                                <span><i class="ri-add-line"></i></span>
                                            </a>
                                        <?php }
                                    } else {
                                        ?>
                                        <a class="watch-list" rel="<?php echo get_the_ID(); ?>">
                                            <?php
                                            echo add_to_watchlist(get_the_ID());
                                            ?>
                                        </a>
                                    <?php } ?>
                                </li>

                            </ul>
                        </div>
                    </div>
                </div>
            <?php

            endwhile;

        endif;
        die();
    }
}

//* video grid**//
add_action('wp_ajax_loadmore_video', 'streamit_video_loadmore_ajax_handler'); // wp_ajax_{action}
add_action('wp_ajax_nopriv_loadmore_video', 'streamit_video_loadmore_ajax_handler'); // wp_ajax_nopriv_{action}
if (!function_exists('streamit_video_loadmore_ajax_handler')) {
    function streamit_video_loadmore_ajax_handler()
    {
        $streamit_options = get_option('streamit_options');
        $args = array(
            'post_type'         => 'video',
            'post_status'       => 'publish',
            'paged' => $_POST['page'] + 1,
            'posts_per_page' => $_POST['setting']['posts_per_page']['size'],

        );
        if (!empty($_POST['setting']['iq_select_videos'])) {
            $args['post__in'] = $_POST['setting']['iq_select_videos'];
        }
        if (empty($_POST['setting']['iq_select_videos']) && $_POST['setting']['post_view_type'] === 'most_liked') {
            $args['post__in'] = iq_get_most_liked('video', array(), 'id');
            $args['orderby'] = 'post__in';
        }
        if (empty($_POST['setting']['iq_select_movies']) && $_POST['setting']['post_view_type'] === 'most_viewd') {
            $args['meta_key']          = 'post_views_count';
            $args['orderby']           = 'meta_value_num';
            $args['order']             = 'DESC';
        }


        if (!empty($_POST['setting']['iq_video_genre'])) {
            $tax_query['taxonomy'] = 'video_cat';
            $tax_query['field'] = 'slug';
            $tax_query['terms'] = $_POST['setting']['iq_video_genre'];
            $tax_query['operator'] = 'IN';
            array_push($taxargs, $tax_query);
        }
        if (!empty($_POST['setting']['iq_video_tag'])) {
            $tax_query['taxonomy'] = 'video_tag';
            $tax_query['field'] = 'slug';
            $tax_query['terms'] = $_POST['setting']['iq_video_tag'];
            $tax_query['operator'] = 'IN';
            array_push($taxargs, $tax_query);
        }

        if (!empty($_POST['setting']['post_view_type']) && $_POST['setting']['post_view_type'] !== 'none') {
            if ($_POST['setting']['post_view_type'] === 'latest') {
                $args['orderby'] = 'publish_date';
                $args['order'] = 'DESC';
            }
        }
        if (!empty($_POST['setting']['order'])  && $_POST['setting']['post_view_type'] === 'upcoming' || $_POST['setting']['post_view_type'] === 'none') {
            $args['order'] = $_POST['setting']['order'];
        }

        if (!empty($tax_query)) {
            $args['tax_query'] = $taxargs;
            $args['tax_query']['relation'] = 'OR';
        }
        query_posts($args);
        if (have_posts()) :

            // run the loop
            while (have_posts()) : the_post();
                $video_run_time = get_post_meta(get_the_ID(), '_video_run_time');
                $video_url_link = get_post_meta(get_the_ID(), '_video_url_link');
                $video_choice = get_post_meta(get_the_ID(), '_video_choice');

                $run_time = '';
                $url_link = '';
                $censor_rating = '';
                if (isset($video_run_time[0])) {
                    $run_time = $video_run_time[0];
                }
                if (isset($video_censor_rating[0])) {
                    $censor_rating = $video_censor_rating[0];
                }

                if (isset($video_choice[0])) {
                    if ($video_choice[0] == 'video_url') {
                        $url_link = $video_url_link[0];
                    } else {
                        $url_link = get_the_permalink();
                    }
                }
                if ($_POST['setting']['video_grid_style'] == '1') {
                    $col = 'col-lg-12 col-md-4 col-sm-6 wl-child';
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
                }
                if ($_POST['setting']['video_grid_style'] == '2') {
                    $col = 'col-lg-6 col-md-4 col-sm-6 wl-child';
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "large");
                }
                if ($_POST['setting']['video_grid_style'] == '3') {
                    $col = 'col-lg-4 col-md-4 col-sm-6 wl-child';
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "medium_large");
                }
                if ($_POST['setting']['video_grid_style'] == '4') {
                    $col = 'col-lg-3 col-md-4 col-sm-6 wl-child';
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "medium_large");
                }
            ?>
                <li class="slide-item <?php echo esc_attr($col); ?>">
                    <style>
                        @media (min-width: 1920px) {
                            <?php
                            $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
                            ?>
                        }
                    </style>
                    <div class="block-images position-relative watchlist-img">
                        <div class="img-box">
                            <img src="<?php echo esc_url($full_image[0]) ?>" class="img-fluid" alt="streamit">
                        </div>
                        <div class="block-description">
                            <h6 class="iq-title">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_title(); ?>
                                </a>
                            </h6>
                            <div class="movie-time d-flex align-items-center my-2">
                                <div class="badge badge-secondary p-1 mr-2"><?php echo esc_html($censor_rating, "streamit-extensions"); ?></div>
                                <span class="text-white"><?php echo esc_html($run_time, "streamit-extensions"); ?></span>
                            </div>
                            <div class="hover-buttons">

                                <a href="<?php the_permalink(); ?>" class="btn btn-hover iq-button">
                                    <i class="fa fa-play mr-1" aria-hidden="true"></i>

                                    <?php echo esc_html($_POST['setting']['play_now_text'], "streamit-extensions"); ?>
                                </a>

                            </div>
                        </div>
                        <div class="block-social-info">
                            <ul class="list-inline p-0 m-0 music-play-lists">
                                <?php if (isset($streamit_options['streamit_display_social_icons'])) {
                                    if ($streamit_options['streamit_display_social_icons'] == 'yes') {
                                ?>
                                        <li class="share">
                                            <span><i class="ri-share-fill"></i></span>
                                            <div class="share-box">
                                                <div class="d-flex align-items-center">
                                                    <a href="https://www.facebook.com/sharer?u=<?php the_permalink(); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="ri-facebook-fill"></i></a>
                                                    <a href="http://twitter.com/intent/tweet?text=<?php the_title(); ?>&url=<?php echo get_the_permalink(); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="ri-twitter-fill"></i></a>
                                                    <a href="#" data-link='<?php the_permalink(); ?>' class="share-ico iq-copy-link"><i class="ri-links-fill"></i></a>
                                                </div>
                                            </div>
                                        </li>
                                <?php }
                                } ?>
                                <?php if (isset($streamit_options['streamit_display_like'])) {
                                    if ($streamit_options['streamit_display_like'] == 'yes') {
                                ?>
                                        <li>
                                            <div class="iq-like-btn"><?php echo do_shortcode('[wp_ulike for="movie" id="' . get_the_ID() . '" style="wpulike-heart"]'); ?></div>
                                        </li>
                                <?php }
                                } ?>
                                <li>
                                    <?php
                                    if (!is_user_logged_in()) {
                                        if (isset($iq_option['streamit_signin_link'])) {
                                            $iqonic_signin_link = get_page_link($iq_option['streamit_signin_link']);

                                    ?>
                                            <a class="watch-list-not" href="<?php echo esc_url($iqonic_signin_link) ?>">
                                                <span><i class="ri-add-line"></i></span>
                                            </a>
                                        <?php }
                                    } else {
                                        ?>
                                        <a class="watch-list" rel="<?php echo get_the_ID(); ?>">
                                            <?php
                                            echo add_to_watchlist(get_the_ID());
                                            ?>
                                        </a>
                                    <?php } ?>
                                </li>

                            </ul>
                        </div>
                    </div>
                </li>
            <?php

            endwhile;

        endif;
        die();
    }
}

//* tvshow grid**//
add_action('wp_ajax_loadmore_tvshow', 'streamit_tvshow_loadmore_ajax_handler'); // wp_ajax_{action}
add_action('wp_ajax_nopriv_loadmore_tvshow', 'streamit_tvshow_loadmore_ajax_handler'); // wp_ajax_nopriv_{action}
if (!function_exists('streamit_tvshow_loadmore_ajax_handler')) {
    function streamit_tvshow_loadmore_ajax_handler()
    {
        $streamit_options = get_option('streamit_options');
        $args = array(
            'post_type'         => 'tv_show',
            'post_status'       => 'publish',
            'paged' => $_POST['page'] + 1,
            'posts_per_page' => $_POST['setting']['posts_per_page']['size'],

        );
        if (!empty($_POST['setting']['iq_select_tv_shows'])) {
            $args['post__in'] = $_POST['setting']['iq_select_tv_shows'];
        }
        if (empty($_POST['setting']['iq_select_tv_shows']) && $_POST['setting']['post_view_type'] === 'most_liked') {
            $args['post__in'] = iq_get_most_liked('tv_show', array(), 'id');
            $args['orderby'] = 'post__in';
        }

        if (!empty($_POST['setting']['iq_tv_show_genre'])) {
            $tax_query['taxonomy'] = 'tv_show_genre';
            $tax_query['field'] = 'slug';
            $tax_query['terms'] = $_POST['setting']['iq_tv_show_genre'];
            $tax_query['operator'] = 'IN';
            array_push($taxargs, $tax_query);
        }

        if (!empty($_POST['setting']['iq_tv_show_tag'])) {
            $tax_query['taxonomy'] = 'tv_show_tag';
            $tax_query['field'] = 'slug';
            $tax_query['terms'] = $_POST['setting']['iq_tv_show_tag'];
            $tax_query['operator'] = 'IN';
            array_push($taxargs, $tax_query);
        }


        if (!empty($_POST['setting']['post_view_type']) && $_POST['setting']['post_view_type'] !== 'none') {
            if ($_POST['setting']['post_view_type'] === 'latest') {
                $args['orderby'] = 'publish_date';
                $args['order'] = 'DESC';
            }
        }
        if (!empty($_POST['setting']['order'])  && $_POST['setting']['post_view_type'] === 'upcoming' || $_POST['setting']['post_view_type'] === 'none') {
            $args['order'] = $_POST['setting']['order'];
        }
        if (empty($_POST['setting']['iq_select_tv_shows']) && $_POST['setting']['post_view_type'] === 'most_viewd') {
            $args['meta_key']          = 'tv_show_views_count';
            $args['orderby']           = 'meta_value_num';
            $args['order']             = 'DESC';
        }
        if (!empty($tax_query)) {
            $args['tax_query'] = $taxargs;
            $args['tax_query']['relation'] = 'OR';
        }
        query_posts($args);
        if (have_posts()) :

            // run the loop
            while (have_posts()) : the_post();


                $movie_run_time = get_post_meta(get_the_ID(), '_movie_run_time');
                $movie_url_link = get_post_meta(get_the_ID(), '_movie_url_link');
                $meta = get_post_meta(get_the_ID());

                $run_time = '';
                $url_link = '';
                if (isset($movie_run_time[0])) {
                    $run_time = $movie_run_time[0];
                }
                if (isset($movie_url_link[0])) {
                    $url_link = $movie_url_link[0];
                }
                $meta = get_post_meta(get_the_ID());
                $season_data = unserialize($meta['_seasons'][0]);

                if ($_POST['setting']['video_grid_style'] == '1') {
                    $col = 'col-lg-12 col-md-4 col-sm-6 wl-child';
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
                }
                if ($_POST['setting']['video_grid_style'] == '2') {
                    $col = 'col-lg-6 col-md-4 col-sm-6 wl-child';
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "large");
                }
                if ($_POST['setting']['video_grid_style'] == '3') {
                    $col = 'col-lg-4 col-md-4 col-sm-6 wl-child';
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "medium_large");
                }
                if ($_POST['setting']['video_grid_style'] == '4') {
                    $col = 'col-lg-3 col-md-4 col-sm-6 wl-child';
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "medium_large");
                }
            ?>
                <li class="slide-item <?php echo esc_attr($col); ?>">
                    <style>
                        @media (min-width: 1920px) {
                            <?php
                            $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
                            ?>
                        }
                    </style>
                    <div class="block-images position-relative watchlist-img">
                        <div class="img-box">
                            <img src="<?php echo esc_url($full_image[0]) ?>" class="img-fluid" alt="streamit">
                        </div>
                        <div class="block-description">
                            <h6 class="iq-title">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_title(); ?>
                                </a>
                            </h6>
                            <div class="movie-time d-flex align-items-center my-2">
                                <div class="badge badge-secondary p-1 mr-2"><?php echo esc_html('15+', "streamit-extensions"); ?></div>
                                <span class="text-white">
                                    <?php if (is_array($season_data))
                                        echo esc_html(count($season_data));
                                    else
                                        echo __('1', "streamit-extensions"); ?>
                                    <?php echo __('Seasons', "streamit-extensions"); ?></span>
                            </div>
                            <div class="hover-buttons">
                                <a href="<?php the_permalink(); ?>" class="btn btn-hover iq-button">
                                    <i class="fa fa-play mr-1" aria-hidden="true"></i>
                                    <?php echo esc_html($_POST['setting']['play_now_text']); ?>
                                </a>
                            </div>
                        </div>
                        <div class="block-social-info">
                            <ul class="list-inline p-0 m-0 music-play-lists">
                                <?php if (isset($streamit_options['streamit_display_social_icons'])) {
                                    if ($streamit_options['streamit_display_social_icons'] == 'yes') {
                                ?>
                                        <li class="share">
                                            <span><i class="ri-share-fill"></i></span>
                                            <div class="share-box">
                                                <div class="d-flex align-items-center">
                                                    <a href="https://www.facebook.com/sharer?u=<?php the_permalink(); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="ri-facebook-fill"></i></a>
                                                    <a href="http://twitter.com/intent/tweet?text=<?php the_title(); ?>&url=<?php echo get_the_permalink(); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="ri-twitter-fill"></i></a>
                                                    <a href="#" data-link='<?php the_permalink(); ?>' class="share-ico iq-copy-link"><i class="ri-links-fill"></i></a>
                                                </div>
                                            </div>
                                        </li>
                                <?php }
                                } ?>
                                <?php if (isset($streamit_options['streamit_display_like'])) {
                                    if ($streamit_options['streamit_display_like'] == 'yes') {
                                ?>
                                        <li>
                                            <div class="iq-like-btn"><?php echo do_shortcode('[wp_ulike for="movie" id="' . get_the_ID() . '" style="wpulike-heart"]'); ?></div>
                                        </li>
                                <?php }
                                } ?>
                                <li>
                                    <?php
                                    if (!is_user_logged_in()) {
                                        if (isset($iq_option['streamit_signin_link'])) {
                                            $iqonic_signin_link = get_page_link($iq_option['streamit_signin_link']);

                                    ?>
                                            <a class="watch-list-not" href="<?php echo esc_url($iqonic_signin_link) ?>">
                                                <span><i class="ri-add-line"></i></span>
                                            </a>
                                        <?php }
                                    } else {
                                        ?>
                                        <a class="watch-list" rel="<?php echo get_the_ID(); ?>">
                                            <?php
                                            echo add_to_watchlist(get_the_ID());
                                            ?>
                                        </a>
                                    <?php } ?>
                                </li>
                            </ul>
                        </div>
                    </div>
                </li>
            <?php

            endwhile;

        endif;
        die();
    }
}


//* view all grid**//
add_action('wp_ajax_loadmore_viewall', 'streamit_viewall_loadmore_ajax_handler'); // wp_ajax_{action}
add_action('wp_ajax_nopriv_loadmore_viewall', 'streamit_viewall_loadmore_ajax_handler'); // wp_ajax_nopriv_{action}
if (!function_exists('streamit_viewall_loadmore_ajax_handler')) {
    function streamit_viewall_loadmore_ajax_handler()
    {
        $streamit_options = get_option('streamit_options');
        $args = array(
            'post_type'         => array('movie', 'tv_show', 'video'),
            'post_status'       => 'publish',
            'paged' => $_POST['page'] + 1,
            'posts_per_page'    => $streamit_options['streamit_post_per_page'],
            'order'    => $streamit_options['streamit_display_order'],
        );
        $current_url = $_POST['href'];
        if (strpos($current_url, 'movies=') || strpos($current_url, 'tv_shows=') || strpos($current_url, 'videos=')) {

            $pos = strpos($current_url, 'movies=');
            if (strpos($current_url, 'tv_shows=')) {
                $pos = strpos($current_url, 'tv_shows=');
            }
            if (strpos($current_url, 'videos=')) {
                $pos = strpos($current_url, 'videos=');
            }
            $len = strlen($current_url);
            $val = substr($current_url, $pos, $len);
            $parts = explode('=', $val);
            $title = $parts[1];
            if (count($parts) > 2)
                $option = $parts[2];
        }
        if ($parts[0] === 'movies') {
            $args['post_type'] = array('movie');
            if (!empty(get_option($option))) {
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'movie_genre',
                        'field' => 'slug',
                        'operator' => 'IN',
                        'terms' => explode(',', get_option($option)),
                    ),
                );
            }
        } elseif ($parts[0] === 'tv_shows') {
            $args['post_type'] = array('tv_show');
            if (!empty(get_option($option))) {
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'tv_show_genre',
                        'field' => 'slug',
                        'operator' => 'IN',
                        'terms' => explode(',', get_option($option)),
                    ),
                );
            }
        } elseif ($parts[0] === 'videos') {
            $args['post_type'] = array('video');
            if (!empty(get_option($option))) {
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'video_cat',
                        'field' => 'slug',
                        'operator' => 'IN',
                        'terms' => explode(',', get_option($option)),
                    ),
                );
            }
        }
        query_posts($args);
        if (have_posts()) :

            // run the loop
            while (have_posts()) : the_post();
                $movie_run_time = get_post_meta(get_the_ID(), '_movie_run_time');
                $video_run_time = get_post_meta(get_the_ID(), '_video_run_time');
                $run_time = '';
                $censor_rating = '';
                if (get_post_type() == 'video') {
                    if (isset($video_run_time[0])) {
                        $run_time = $video_run_time[0];
                    }
                } else if (get_post_type() == 'tv_show') {
                    $meta = get_post_meta(get_the_ID());
                    $season_data = unserialize($meta['_seasons'][0]);

                    if (isset($season_data)) {
                        if (is_array($season_data)) {
                            $run_time = count($season_data) . ' Seasons';
                        } else {
                            $run_time = '1 Seasons';
                        }
                    }
                } else {
                    if (isset($movie_run_time[0])) {
                        $run_time = $movie_run_time[0];
                    }

                    if (isset($movie_censor_rating[0])) {
                        $censor_rating = $movie_censor_rating[0];
                    }
                }

                $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "medium_large");
            ?>
                <article class="col-lg-3 col-md-4 col-sm-6 wl-child">
                    <style>
                        @media (min-width: 1920px) {
                            <?php
                            $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
                            ?>
                        }
                    </style>
                    <div class="block-images position-relative watchlist-img">
                        <div class="img-box">
                            <img src="<?php echo esc_url($full_image[0]) ?>" class="img-fluid" alt="">
                        </div>
                        <div class="block-description">
                            <h6 class="iq-title">
                                <a href="<?php the_permalink();  ?>">
                                    <?php the_title(); ?>
                                </a>
                            </h6>
                            <div class="movie-time d-flex align-items-center my-2">
                                <div class="badge badge-secondary p-1 mr-2"><?php echo esc_html($censor_rating); ?></div>
                                <span class="text-white"><?php echo esc_html($run_time); ?></span>
                            </div>
                            <div class="hover-buttons">

                                <a href="<?php the_permalink();  ?>" class="btn btn-hover iq-button">
                                    <i class="fa fa-play mr-1" aria-hidden="true"></i>
                                    <?php _e('Play Now', 'streamit-extension') ?>
                                </a>

                            </div>
                        </div>
                        <div class="block-social-info">
                            <ul class="list-inline p-0 m-0 music-play-lists">
                                <?php if (isset($streamit_options['streamit_display_social_icons'])) {
                                    if ($streamit_options['streamit_display_social_icons'] == 'yes') {
                                ?>
                                        <li>
                                            <span><i class="ri-share-fill"></i></span>
                                            <div class="share-box">
                                                <div class="d-flex align-items-center">
                                                    <a href="https://www.facebook.com/sharer?u=<?php the_permalink(); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="ri-facebook-fill"></i></a>
                                                    <a href="http://twitter.com/intent/tweet?text=<?php the_title(); ?>&url=<?php echo get_the_permalink(); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="ri-twitter-fill"></i></a>
                                                    <a href="#" data-link='<?php the_permalink(); ?>' class="share-ico iq-copy-link"><i class="ri-links-fill"></i></a>
                                                </div>
                                            </div>
                                        </li>
                                <?php }
                                } ?>
                                <?php if (isset($streamit_options['streamit_display_like'])) {
                                    if ($streamit_options['streamit_display_like'] == 'yes') {
                                ?>
                                        <li>
                                            <div class="iq-like-btn"><?php echo do_shortcode('[wp_ulike for="movie" id="' . get_the_ID() . '" style="wpulike-heart"]'); ?></div>
                                        </li>
                                <?php }
                                } ?>
                                <li>
                                    <a class="watch-list" rel="<?php echo get_the_ID(); ?>">
                                        <?php
                                        echo add_to_watchlist(get_the_ID());
                                        ?>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </article>
            <?php
            endwhile;

        endif;
        die();
    }
}



//* watchlist grid**//
add_action('wp_ajax_loadmore_watchlist', 'streamit_watchlist_loadmore_ajax_handler'); // wp_ajax_{action}
add_action('wp_ajax_nopriv_loadmore_watchlist', 'streamit_watchlist_loadmore_ajax_handler'); // wp_ajax_nopriv_{action}
if (!function_exists('streamit_watchlist_loadmore_ajax_handler')) {
    function streamit_watchlist_loadmore_ajax_handler()
    {
        $streamit_options = get_option('streamit_options');
        $user = wp_get_current_user();
        $user_id = $user->ID;
        $watchlist = get_user_meta($user_id, '_user_watchlist', true);
        $args = array(
            'post_type'         => array('movie', 'tv_show', 'video'),
            'post_status'       => 'publish',
            'post__in'          => explode(',', $watchlist),
            'paged' => $_POST['page'] + 1,
            'posts_per_page'    => $streamit_options['streamit_post_per_page'],

        );
        query_posts($args);
        if (have_posts()) :

            // run the loop
            while (have_posts()) : the_post();
                $movie_logo = get_field('movie_logo', get_the_ID());
                $trailer_link = get_field('movie_trailer_link', get_the_ID());
                $movie_run_time = get_post_meta(get_the_ID(), '_movie_run_time');
                $movie_url_link = get_post_meta(get_the_ID(), '_movie_url_link');
                $movie_choice = get_post_meta(get_the_ID(), '_movie_choice');
                $meta = get_post_meta(get_the_ID());

                $run_time = '';
                $url_link = '';
                $censor_rating = '';
                if (isset($movie_run_time[0])) {
                    $run_time = $movie_run_time[0];
                }
                if (isset($movie_censor_rating[0])) {
                    $censor_rating = $movie_censor_rating[0];
                }


                if (isset($movie_choice[0])) {
                    if ($movie_choice[0] == 'movie_url') {
                        $url_link = $movie_url_link[0];
                    } else {
                        $url_link = get_the_permalink();
                    }
                } else {
                    $url_link = get_the_permalink();
                }
                $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "medium_large");
            ?>

                <div class="col-lg-3 col-md-4 col-sm-6 wl-child">
                    <style>
                        @media (min-width: 1920px) {
                            <?php
                            $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
                            ?>
                        }
                    </style>
                    <div class="block-images position-relative watchlist-img">
                        <div class="img-box">
                            <img src="<?php echo esc_url($full_image[0]) ?>" class="img-fluid" alt="">
                        </div>
                        <div class="block-description">
                            <h6 class="iq-title">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_title(); ?>
                                </a>
                            </h6>
                            <div class="movie-time d-flex align-items-center my-2">
                                <div class="badge badge-secondary p-1 mr-2"><?php echo esc_html($censor_rating); ?></div>
                                <span class="text-white"><?php echo esc_html($run_time); ?></span>
                            </div>
                            <div class="hover-buttons">

                                <a href="<?php the_permalink(); ?>" class="btn btn-hover iq-button">
                                    <i class="fa fa-play mr-1" aria-hidden="true"></i>
                                    <?php echo esc_html('Play Now', "streamit-extensions"); ?>
                                </a>

                            </div>
                        </div>
                        <div class="block-social-info">
                            <ul class="list-inline p-0 m-0 music-play-lists">
                                <?php if (isset($streamit_options['streamit_display_social_icons'])) {
                                    if ($streamit_options['streamit_display_social_icons'] == 'yes') {
                                ?>
                                        <li class="share">
                                            <span><i class="ri-share-fill"></i></span>
                                            <div class="share-box">
                                                <div class="d-flex align-items-center">
                                                    <a href="https://www.facebook.com/sharer?u=<?php the_permalink(); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="ri-facebook-fill"></i></a>
                                                    <a href="http://twitter.com/intent/tweet?text=<?php the_title(); ?>&url=<?php echo get_the_permalink(); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="ri-twitter-fill"></i></a>
                                                    <a href="#" data-link='<?php the_permalink(); ?>' class="share-ico iq-copy-link"><i class="ri-links-fill"></i></a>
                                                </div>
                                            </div>
                                        </li>
                                <?php }
                                } ?>
                                <?php if (isset($streamit_options['streamit_display_like'])) {
                                    if ($streamit_options['streamit_display_like'] == 'yes') {
                                ?>
                                        <li>
                                            <div class="iq-like-btn"><?php echo do_shortcode('[wp_ulike for="movie" id="' . get_the_ID() . '" style="wpulike-heart"]'); ?></div>
                                        </li>
                                <?php }
                                } ?>
                                <li>
                                    <a class="watch-list" rel="<?php echo get_the_ID(); ?>">
                                        <?php
                                        echo add_to_watchlist(get_the_ID());
                                        ?>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            <?php
            endwhile;

        endif;
        die();
    }
}



//* Blog grid Shortcode**//
add_action('wp_ajax_loadmore_blog_grid', 'streamit_blog_grid_loadmore_ajax_handler'); // wp_ajax_{action}
add_action('wp_ajax_nopriv_loadmore_blog_grid', 'streamit_blog_grid_loadmore_ajax_handler'); // wp_ajax_nopriv_{action}
if (!function_exists('streamit_blog_grid_loadmore_ajax_handler')) {
    function streamit_blog_grid_loadmore_ajax_handler()
    {
        $streamit_options = get_option('streamit_options');
        if (isset($_POST['setting']['blog_cat']) && !empty($_POST['setting']['blog_cat'])) {
            $cat = implode(',', $_POST['setting']['blog_cat']);
        }
        $args = array(
            'post_type'         => 'post',
            'posts_per_page'     => $_POST['setting']['posts_per_page']['size'],
            'paged'                => $_POST['page'] + 1,
            'post_status'       => 'publish',
            'category_name'        => $cat,
            'order'               => $_POST['setting']['order'],
            'suppress_filters'  => 0
        );
        if ($_POST['setting']['blog_style'] === "2") {
            $col = 'col-lg-12 iqonic-space-bottom';
        }
        if ($_POST['setting']['blog_style'] === "3") {
            $col = 'col-lg-6 col-md-6 iqonic-space-bottom';
        }
        if ($_POST['setting']['blog_style'] === "4") {
            $col = 'col-lg-4 col-md-6 iqonic-space-bottom';
        }
        query_posts($args);
        if (have_posts()) :

            // run the loop
            while (have_posts()) : the_post();
                $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");

            ?>
                <div class="<?php echo esc_attr__($col, "streamit-extensions") ?>">
                    <div class="iq-blog-box">
                        <div class="iq-blog-image clearfix">
                            <?php echo sprintf('<img src="%1$s" alt="iqonic-blog"/>', esc_url($full_image[0], "streamit-extensions"));

                            $postcat = get_the_category();
                            if ($postcat) {
                            ?>
                                <ul class="iq-blogtag">
                                    <?php
                                    foreach ($postcat as $cat) {
                                    ?>
                                        <li><a href="<?php echo get_category_link($cat->cat_ID); ?>"><?php echo $cat->name; ?></a></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            <?php
                            }
                            ?>


                        </div>
                        <div class="iq-blog-detail">
                            <div class="iq-blog-meta">

                                <ul class="iq-postdate">
                                    <li class="list-inline-item">
                                        <?php echo sprintf("%s", iqonic_blog_time_link()); ?>
                                    </li>

                                </ul>

                            </div>

                            <div class="blog-title">
                                <a href="<?php the_permalink(); ?>">
                                    <h4 class="mb-3"><?php the_title(); ?></h4>
                                </a>

                            </div>
                            <?php the_excerpt(); ?>
                            <div class="blog-button">
                                <a class="iq-btn-link" href="<?php the_permalink(); ?>"><?php echo sprintf("%s", __('Read More', "streamit-extensions")); ?><i class="fa fa-angle-right ml-2" aria-hidden="true"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php

            endwhile;

        endif;
        die();
    }
}


//* genres grid**//
add_action('wp_ajax_loadmore_genres', 'streamit_genres_loadmore_ajax_handler'); // wp_ajax_{action}
add_action('wp_ajax_nopriv_loadmore_genres', 'streamit_genres_loadmore_ajax_handler'); // wp_ajax_nopriv_{action}
if (!function_exists('streamit_genres_loadmore_ajax_handler')) {
    function streamit_genres_loadmore_ajax_handler()
    {
        $post_type = '';
        $iq_option = get_option('streamit_options');
        if (isset($_POST['setting']['slider_title'])) {
            $slider_title = $_POST['setting']['slider_title'];
            $slider_title_key  = str_replace(" ", "_", $slider_title);

            $title_option = 'm12iqt' . $slider_title_key;
            if (!get_option($title_option)) {
                update_option($title_option, $slider_title);
            }
            $view_title = $title_option;
        }
        $terms_per_page = $_POST['setting']['posts_per_page']['size'];
        $current_page = $_POST['page'] + 1;
        $offset = ($terms_per_page * $current_page) - $terms_per_page;
        $args = array(
            'post_type'         => array('tv_show', 'movie', 'video'),
            'post_status'       => 'publish',
            'order'    => $_POST['setting']['order'],
        );
        if ($terms_per_page == -1) {
            $args['paged'] = $current_page;
            $args['posts_per_page'] = -1;
        } else {
            $args['number']   = $terms_per_page;
            $args['offset']   = $offset;
        }
        if ($_POST['setting']['iq_type'] == 'video') {
            $terms =  get_terms('video_cat', $args);
            $post_type = 'videos';
        } else if ($_POST['setting']['iq_type'] == 'tv_show') {
            $terms =  get_terms('tv_show_genre', $args);
            $post_type = 'tv_shows';
        } else {
            $terms =  get_terms('movie_genre', $args);
            $post_type = 'movies';
        }
        if ($terms) {
            foreach ($terms as $term) {
                $args['category_name']  = $term->slug;
                $thumbnail_id = get_term_meta($term->term_id, 'thumbnail_id', true);

                if (!empty($thumbnail_id)) {
                    $full_image =  wp_get_attachment_url($thumbnail_id);
                } else {
                    $full_image =   IQ_TH_URL . '/assest/img/placeholder_genre.jpg';
                }

                if ($_POST['setting']['movie_grid_style'] == '1') {
                    $col = 'col-lg-12 col-md-4 col-sm-6 wl-child';
                }
                if ($_POST['setting']['movie_grid_style'] == '2') {
                    $col = 'col-lg-6 col-md-4 col-sm-6 wl-child';
                }
                if ($_POST['setting']['movie_grid_style'] == '3') {
                    $col = 'col-lg-4 col-md-4 col-sm-6 wl-child';
                }
                if ($_POST['setting']['movie_grid_style'] == '4') {
                    $col = 'col-lg-3 col-md-4 col-sm-6 wl-child';
                }
            ?>
                <div class="slide-item <?php echo esc_attr($col); ?>">
                    <div class="block-images position-relative watchlist-img">
                        <div class="img-box">
                            <img src="<?php echo esc_url($full_image) ?>" class="img-fluid" alt="streamit">
                        </div>
                        <div class="block-description">
                            <h6 class="iq-title">
                                <a href="<?php echo get_term_link($term); ?>">
                                    <?php
                                    $view_list = substr($term->slug, 0, 3);
                                    $view_cat =  $view_title . '=m12iq_' . $view_list;
                                    update_option('m12iq_' . $view_list, $term->slug);
                                    $view_all = '<a href="' . esc_url(get_page_link($iq_option['streamit_viewall_link'])) . '?' . $post_type . '=' .  esc_html($view_cat, "streamit-extensions") . '">' .  esc_html($term->name) . '</a>';
                                    echo wp_kses_post($view_all);
                                    ?>
                                </a>
                            </h6>
                        </div>
                    </div>
                </div>
<?php

            }
        }
        die();
    }
}
