<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 

class Iq_Tv_Show_Tab extends Widget_Base {

	public function get_name() {
		return __( 'Iq_Tv_Show_Tab',"streamit-extensions" );
	}
	
	public function get_title() {
		return __( 'Tv Show Tab',"streamit-extensions" );
	}

	public function get_categories() {
		return [ 'streamit-extensions' ];
	}
	
	/**
	 * Get widget icon.
	 *
	 * Retrieve heading widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-person';
	}
	
	protected function _register_controls() {

		
		$this->start_controls_section(
			'section_Team',
			[
				'label' => __( 'Tv Show Banner',"streamit-extensions" ),
			]
        );
        $this->add_control(
			'trending_top_img',
			[
                'label' => __( 'Trending Order Image',"streamit-extensions" ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => IQ_TH_URL . '/assest/img/placeholder.jpg',
                ],
				
			]
        );

		$this->add_control(
			'show_title',
			[
				'label'   => __('Show Title', "streamit-extensions"),
				'type'    => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => esc_html__('yes', "streamit-extensions"),
					'no' => esc_html__('no', "streamit-extensions")
				],

			]
		);

		$this->add_control(
			'title_text',
			[
				'label' => __('Trending', "streamit-extensions"),
				'type' => Controls_Manager::TEXT,
				'default' => __('Trending', "streamit-extensions"),
				'label_block' => true,
				'condition' => ['show_title' => ['yes']]
			]
		);

		$this->add_control(
			'tab_text_overview',
			[
				'label' => __('Overview Tab Text', "streamit-extensions"),
				'type' => Controls_Manager::TEXT,
				'default' => __('Overview', "streamit-extensions"),
				'label_block' => true,
			]
		);

		$this->add_control(
			'tab_text_episode',
			[
				'label' => __('Episode Tab Text', "streamit-extensions"),
				'type' => Controls_Manager::TEXT,
				'default' => __('Episodes', "streamit-extensions"),
				'label_block' => true,
			]
		);

        $this->add_control(
			'view_logo',
			[
				'label' => __( 'Show logo?', 'streamit-extensions' ),
				'type' => Controls_Manager::SELECT,
                'default' => 'block',
                'options' => [
                    'block' => esc_html__('yes',"streamit-extensions"),
                    'none' => esc_html__('no',"streamit-extensions")
                ],
                'selectors' => [
                    '{{WRAPPER}} .iq-tvshow-tabs .channel-logo' => 'display: {{value}};',
                ],
			]
		);
		$this->add_control(
			'view_all_starring',
			[
				'label' => __( 'Show Starring?', 'streamit-extensions' ),
				'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'block',
                'options' => [
                    'block' => esc_html__('yes',"streamit-extensions"),
                    'none' => esc_html__('no',"streamit-extensions")
                ],
                'selectors' => [
                    '{{WRAPPER}} .iq-tvshow-tabs .text-primary.title.starring' => 'display: {{value}};',
                ],
			]
		);

		$this->add_control(
			'view_all_genres',
			[
				'label' => __( 'Show Genres?', 'streamit-extensions' ),
				'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'block',
                'options' => [
                    'block' => esc_html__('yes',"streamit-extensions"),
                    'none' => esc_html__('no',"streamit-extensions")
                ],
                'selectors' => [
                    '{{WRAPPER}} .iq-tvshow-tabs .text-primary.title.genres' => 'display: {{value}};',
                ],
			]
		);

		$this->add_control(
			'view_all_tag',
			[
				'label' => __( 'Show Tags?', 'streamit-extensions' ),
				'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'block',
                'options' => [
                    'block' => esc_html__('yes',"streamit-extensions"),
                    'none' => esc_html__('no',"streamit-extensions")
                ],
                'selectors' => [
                    '{{WRAPPER}} .iq-tvshow-tabs .text-primary.title.tag' => 'display: {{value}};',
                ],
			]
		);
	
        $this->end_controls_section();

	}
	
	protected function render() {
		$settings = $this->get_settings();
		require  IQ_TH_ROOT . '/inc/elementor/render/tv_show-tab.php';
    }	    
		
}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Iq_Tv_Show_Tab() );