<?php

namespace Elementor;

$html = '';
if (!defined('ABSPATH')) exit;

$settings = $this->get_settings();
$streamit_options = get_option('streamit_options');
$args = array();
$tax_query = array();
$id_int = rand(10, 100);
$tabs = $this->get_settings_for_display('tabs');
$this->add_render_attribute('slider', 'data-nav', $settings['nav-arrow']);
$this->add_render_attribute('slider', 'data-autoplay', $settings['autoplay']);
$this->add_render_attribute('slider', 'data-speed', $settings['speed']);
?>

<div id="home" class="iq-main-slider p-0 iq-rtl-direction iq-home-banner-slider">
    <div id="<?php echo esc_attr('home-slider-' . $id_int); ?>" data-rand="<?php echo esc_attr('home-slider-' . $id_int); ?>" class="home-slider slider m-0 p-0" <?php  echo $this->get_render_attribute_string('slider'); ?>>
        <?php
        foreach ($tabs as $index => $item) {

            $args = array(
                'post_type'         => array('tv_show', 'movie', 'video'),
                'post_status'       => 'publish',
            );
            if (!empty($item['iq_video']) && $item['iq_type'] === 'video') {
                $args['p'] = $item['iq_video'];
            }
            if (!empty($item['iq_tv_show']) && $item['iq_type'] === 'tv_show') {
                $args['p'] = $item['iq_tv_show'];
            }
            if (!empty($item['iq_movie']) && $item['iq_type'] === 'movie') {
                $args['p'] = $item['iq_movie'];
            }

            $wp_query = new \WP_Query($args);
            if ($wp_query->have_posts()) {

                while ($wp_query->have_posts()) {
                    $wp_query->the_post();
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id($wp_query->ID), "full");
                    $movie_logo = get_field('name_logo', get_the_ID());
                    $trailer_link = get_field('name_trailer_link', get_the_ID());
                    $movie_run_time = get_post_meta(get_the_ID(), '_movie_run_time');
                    $movie_url_link = get_post_meta(get_the_ID(), '_movie_url_link');
                    $video_run_time = get_post_meta(get_the_ID(), '_video_run_time');
                    $movie_censor_rating = get_post_meta(get_the_ID(), '_movie_censor_rating');
                    $movie_choice = get_post_meta(get_the_ID(), '_movie_choice');
                    $movie_cast = get_post_meta(get_the_ID(), '_cast');
                    $movie_imdb_rating = get_post_meta(get_the_ID(), 'name_custom_imdb_rating');
                    $run_time = '';
                    $url_link = '';
                    $censor_rating = '';
                    $imdb_rating = '';
                    if ($item['iq_type'] === 'video') {
                        if (isset($video_run_time[0])) {
                            $run_time = $video_run_time[0];
                        }
                    } else if ($item['iq_type'] === 'tv_show') {
                        $meta = get_post_meta(get_the_ID());
                        $season_data = unserialize($meta['_seasons'][0]);

                        if (isset($season_data)) {
                            if (is_array($season_data)) {
                                $censor_rating = count($season_data) . ' Seasons';
                            } else {
                                $censor_rating = '1 Seasons';
                            }
                        }
                    }
                    if (isset($movie_run_time[0])) {
                        $run_time = $movie_run_time[0];
                    }

                    if (isset($movie_censor_rating[0])) {
                        $censor_rating = $movie_censor_rating[0];
                    }
                    if (isset($movie_imdb_rating[0])) {
                        $imdb_rating = $movie_imdb_rating[0];
                        $imdb_text = '';
                        if ($streamit_options['streamit_imdb_display_rating'] === 'yes') {
                            if ($streamit_options['streamit_display_single_star'] === 'no') {
                                $imdb_rating = $imdb_rating;
                                $imdb_text = 'single_star';
                            }
                        } else {
                            $imdb_rating = floatval($imdb_rating) / 2;
                        }
                    }
                    if (isset($movie_choice[0])) {
                        if ($movie_choice[0] == 'movie_url') {
                            $url_link = $movie_url_link[0];
                        } else {
                            $url_link = get_the_permalink();
                        }
                    }

                    $cast = '';
                    $genre = '';
                    $tag = '';
                    if ($item['iq_type'] === 'video') {
                    } else {

                        $m_cast = $movie_cast[0];
                        if (is_array($m_cast)) {
                            $j = 1;
                            foreach ($m_cast as $data) {
                                $cast_obj = get_post($data['id']);
                                if ($j === 1)
                                    $cast = '<a href="' . $cast_obj->guid . '"><span class="text-body">' . $cast_obj->post_title . '</span></a>';
                                else
                                    $cast .= ", " . '<a href="' . $cast_obj->guid . '"><span class="text-body">' . $cast_obj->post_title . '</span></a>';
                                $j++;
                            }
                        }
                    }
                    if ($item['iq_type'] === 'tv_show') {
                        $wp_object = wp_get_post_terms(get_the_ID(), 'tv_show_genre');
                    } else if ($item['iq_type'] === 'video') {
                        $wp_object = wp_get_post_terms(get_the_ID(), 'video_cat');
                    } else {
                        $wp_object = wp_get_post_terms(get_the_ID(), 'movie_genre');
                    }

                    if (!empty($wp_object)) {
                        $k = 1;
                        foreach ($wp_object as $val) {
                            if ($k == 1)
                                $genre = '<a href="' . get_term_link($val) . '"><span class="text-body">' . $val->name . '</span></a>';
                            else
                                $genre .= ', ' . '<a href="' . get_term_link($val) . '"><span class="text-body">' . $val->name . '</span></a>';;
                            $k++;
                        }
                    }

                    if ($item['iq_type'] === 'tv_show') {
                        $wp_object = wp_get_post_terms(get_the_ID(), 'tv_show_tag');
                    } else if ($item['iq_type'] === 'video') {
                        $wp_object = wp_get_post_terms(get_the_ID(), 'video_tag');
                    } else {
                        $wp_object = wp_get_post_terms(get_the_ID(), 'movie_tag');
                    }

                    if (!empty($wp_object)) {
                        $l = 1;
                        foreach ($wp_object as $val) {
                            if ($l == 1)
                                $tag = '<a href="' . get_term_link($val) . '"><span class="text-body">' . $val->name . '</span></a>';
                            else
                                $tag .= ', ' . '<a href="' . get_term_link($val) . '"><span class="text-body">' . $val->name . '</span></a>';
                            $l++;
                        }
                    }
                    update_post_meta(get_the_ID(), 'iq_slider_back_image', $item['slider_image']['url']);

        ?>
                    <div class="slide slick-bg" style="background:url('<?php
                                                                        if (!empty($item['slider_image']['url'])) {
                                                                            echo esc_url($item['slider_image']['url']);
                                                                        } else {
                                                                            if (has_post_thumbnail()) {
                                                                                echo esc_url($full_image[0]);
                                                                            }
                                                                        } ?>')">
                        <div class="container-fluid position-relative h-100">
                            <div class="slider-inner h-100">
                                <div class="row align-items-center  h-100">
                                    <div class="col-lg-7 col-md-12">
                                        <a href="javascript:void(0);">
                                            <div class="channel-logo" data-animation-in="fadeInLeft">
                                                <img src="<?php echo esc_url($movie_logo['url']); ?>" class="c-logo" alt="streamit">
                                            </div>
                                        </a>
                                        <h1 class="slider-text big-title title text-uppercase" data-animation-in="fadeInLeft"><?php the_title(); ?></h1>
                                        <div class="d-flex flex-wrap align-items-center" data-animation-in="fadeInLeft">
                                            <?php if (isset($movie_imdb_rating[0]) && !empty($movie_imdb_rating[0])) { ?>
                                                <div class="slider-ratting d-flex align-items-center mr-4 mt-2 mt-md-3">
                                                    <ul class="ratting-start p-0 m-0 list-inline text-primary d-flex align-items-center justify-content-left">
                                                        <?php
                                                        if (isset($streamit_options['streamit_imdb_display_rating']) && $streamit_options['streamit_imdb_display_rating'] == 'yes' && $streamit_options['streamit_display_single_star'] == 'yes') {
                                                        ?>
                                                            <li>
                                                                <i class="fa fa-star" aria-hidden="true"></i>
                                                            </li>
                                                            <?php
                                                        } else {
                                                            for ($i = 1; $i <= ceil($imdb_rating); $i++) {
                                                                if (($imdb_rating - floor($imdb_rating)) > 0 && $i == ceil($imdb_rating)) {
                                                            ?>
                                                                    <li>
                                                                        <i class="fa fa-star-half" aria-hidden="true"></i>
                                                                    </li>
                                                                <?php
                                                                    continue;
                                                                }
                                                                ?>
                                                                <li class="<?php esc_attr_e($imdb_text); ?>">
                                                                    <i class="fa fa-star" aria-hidden="true"></i>
                                                                </li>
                                                        <?php
                                                            }
                                                        }
                                                        ?>
                                                    </ul>
                                                    <span class="text-white ml-2"><?php echo esc_html(round($imdb_rating, 1) . '(lmdb)', "streamit-extensions"); ?></span>
                                                </div>
                                            <?php } ?>
                                            <div class="d-flex align-items-center mt-2 mt-md-3">
                                                <span class="badge badge-secondary p-2">
                                                    <?php if ($item['iq_type'] === 'video') {
                                                        if (function_exists('set_post_view')) {
                                                    ?>
                                                            <i class="fa fa-eye"></i>
                                                    <?php if (get_post_view() == 0) {
                                                                echo esc_html('0 Views');
                                                            } else {
                                                                echo get_post_view();
                                                            };
                                                        }
                                                    } else {
                                                        echo esc_html($censor_rating);
                                                    } ?></span>
                                                <span class="ml-3"><?php if ($item['iq_type'] === 'tv_show') {
                                                                        echo get_the_date('M Y');
                                                                    } else {
                                                                        echo esc_html($run_time);
                                                                    } ?></span>
                                            </div>
                                        </div>

                                        <p data-animation-in="fadeInUp" data-delay-in="1.2">
                                            <?php
                                            $iq_excerpt = get_the_excerpt();
                                            if (!empty($iq_excerpt)) {
                                                $iq_remove_tags = array("<p>", "</p>");
                                                $iq_excerpt = str_replace($iq_remove_tags, "", $iq_excerpt);
                                                echo __($iq_excerpt, "streamit-extensions");
                                            }
                                            ?>
                                        </p>
                                        <div class="trending-list" data-wp_object-in="fadeInUp" data-delay-in="1.2">
                                            <?php if ($item['iq_type'] === 'video') {
                                            } else { ?>
                                                <?php if (!empty($cast)) { ?>
                                                    <div class="text-primary title starring">
                                                        <?php if (!empty($streamit_options['streamit_starring_title'])) {
                                                            echo esc_attr($streamit_options['streamit_starring_title'], 'streamit-extensions');
                                                        } else {
                                                            echo __('Starring:', "streamit-extensions");
                                                        } ?> <span class="text-body"><?php echo rtrim($cast, ","); ?></span>
                                                    </div>
                                            <?php }
                                            } ?>
                                            <?php if (!empty($genre)) { ?>
                                                <div class="text-primary title genres">
                                                    <?php if (!empty($streamit_options['streamit_genres_title'])) {
                                                        echo esc_attr($streamit_options['streamit_genres_title'], 'streamit-extensions');
                                                    } else {
                                                        echo __('Genres:', "streamit-extensions");
                                                    } ?> <span class="text-body"><?php echo rtrim($genre, ","); ?></span>
                                                </div>
                                            <?php } ?>
                                            <?php if (!empty($tag)) { ?>
                                                <div class="text-primary title tag">
                                                    <?php if (!empty($streamit_options['streamit_tag_title'])) {
                                                        echo esc_attr($streamit_options['streamit_tag_title'], 'streamit-extensions');
                                                    } else {
                                                        echo __('Tag:', "streamit-extensions");
                                                    } ?> <span class="text-body"><?php echo rtrim($tag, ","); ?></span>
                                                </div>
                                            <?php } ?>
                                        </div>
                                        <?php
                                        if (isset($settings['show_view_all_btn'])) {
                                            if ($settings['show_view_all_btn'] == 'yes') {
                                        ?>
                                                <div class="d-flex align-items-center r-mb-23" data-animation-in="fadeInUp" data-delay-in="1.3">
                                                    <a href="<?php the_permalink(); ?>" class="btn btn-hover iq-button"><i class="fa fa-play mr-2" aria-hidden="true"></i>
                                                        <?php
                                                        if (!empty($settings['play_now_text'])) {
                                                            echo esc_attr($settings['play_now_text'], 'streamit-extensions');
                                                        } else {
                                                            echo __('Play Now', 'streamit-extensions');
                                                        }
                                                        ?>
                                                    </a>
                                                </div>
                                        <?php }
                                        }  ?>
                                    </div>
                                    <div class="col-lg-5 col-md-12 trailor-video iq-slider">
                                        <a href="<?php echo esc_url($trailer_link); ?>" class="video-open playbtn">
                                            <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="80px" height="80px" viewBox="0 0 213.7 213.7" enable-background="new 0 0 213.7 213.7" xml:space="preserve">
                                                <polygon class='triangle' fill="none" stroke-width="7" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" points="73.5,62.5 148.5,105.8 73.5,149.1 " />
                                                <circle class='circle' fill="none" stroke-width="7" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" cx="106.8" cy="106.8" r="103.3" />
                                            </svg>
                                            <?php
                                            if (!empty($settings['trailer_text'])) {
                                            ?>
                                                <span class="w-trailor"><?php echo esc_html($settings['trailer_text'], "streamit-extensions") ?></span>
                                            <?php }  ?>
                                        </a>
                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>

        <?php }
            }
        } ?>

    </div>
    <svg xmlns="http://www.w3.org/2000/svg" style="display: none;">
        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="0 0 44 44" width="44px" height="44px" id="circle" fill="none" stroke="currentColor">
            <circle r="20" cy="22" cx="22" id="test"></circle>
        </symbol>
    </svg>
</div>