<?php
if (!class_exists('ReduxFramework')) {
    return;
}

add_action('wp_head', 'streamit_header_background_style');
add_action('wp_enqueue_scripts', 'streamit_menu_color_options', 20);
add_action('wp_enqueue_scripts', 'streamit_sub_menu_color_options', 20);
add_action('wp_enqueue_scripts', 'streamit_responsive_menu_color_options', 20);
add_action('wp_enqueue_scripts', 'streamit_action_btn_color_options', 20);

function streamit_header_background_style()
{
    $streamit_options = get_option('streamit_options');
    $page_id = get_queried_object_id();
    $dynamic_css = array();

    if (get_field('name_header_display', $page_id) == 'no') {
        $dynamic_css[] = array(
            'elements'  =>  'header',
            'property'  =>  'display',
            'value'     =>  'none !important'
        );
    } else if (get_field('name_header_display', $page_id) == 'yes') {
        $dynamic_css[] = array(
            'elements'  =>  '.iq-register .elementor-shortcode',
            'property'  =>  'padding-top',
            'value'     =>  '75px'
        );
    } else if (isset($streamit_options['streamit_header_variation'])  && $streamit_options['streamit_header_variation'] != '3') {
        if (isset($streamit_options['streamit_header_background_type']) && $streamit_options['streamit_header_background_type'] != 'default') {
            $type = $streamit_options['streamit_header_background_type'];
            if ($type == 'color') {
                if (!empty($streamit_options['streamit_header_background_color'])) {
                    $dynamic_css[] = array(
                        'elements'  =>  'header#main-header',
                        'property'  =>  'background',
                        'value'     =>  '' . $streamit_options['streamit_header_background_color'] . ' !important'
                    );
                }
            }

            if ($type == 'image') {
                if (!empty($streamit_options['streamit_header_background_image']['url'])) {
                    $dynamic_css[] = array(
                        'elements'  =>  'header#main-header',
                        'property'  =>  'background',
                        'value'     =>  'url(' . $streamit_options['streamit_header_background_image']['url'] . ') !important'
                    );
                }
            }

            if ($type == 'transparent') {

                $dynamic_css[] = array(
                    'elements'  =>  'header#main-header',
                    'property'  =>  'background',
                    'value'     =>  'transparent !important'
                );
            }
        }
    } else {
    }
    if (count($dynamic_css) > 0) {
        echo "<style type='text/css' id='streamit-dynamic-css" . rand(10, 100000) . "'>\n\n";
        streamit_dynamic_style($dynamic_css);
        echo '</style>';
    }
}

function streamit_menu_color_options()
{
    $streamit_options = get_option('streamit_options');
    $inline_css = '';

    if (isset($streamit_options['streamit_header_variation'])  && $streamit_options['streamit_header_variation'] != '3') {
        if (isset($streamit_options['header_menu_color_type']) && $streamit_options['header_menu_color_type'] == 'custom') {

            if (isset($streamit_options['streamit_header_menu_color']) && !empty($streamit_options['streamit_header_menu_color'])) {
                $inline_css .= 'header .navbar ul li a,header .navbar ul li i{
                    color : ' . $streamit_options['streamit_header_menu_color'] . '!important;
                }';
            }

            if (isset($streamit_options['streamit_header_menu_active_color']) && !empty($streamit_options['streamit_header_menu_active_color'])) {
                $inline_css .= ' header .navbar ul li.current-menu-item a, header .navbar ul li.current-menu-parent > a, header .navbar ul li.current-menu-parent i, header .navbar ul li.current-menu-item i, header .navbar ul li.current-menu-ancestor> a, header .navbar ul li.current-menu-ancestor> i{
                    color : ' . $streamit_options['streamit_header_menu_active_color'] . ' !important;
                }';
            }

            if (isset($streamit_options['streamit_header_menu_hover_color']) && !empty($streamit_options['streamit_header_menu_hover_color'])) {
                $inline_css .= 'header .navbar ul li:hover > a,header .navbar ul li:hover > i{
                    color : ' . $streamit_options['streamit_header_menu_hover_color'] . ' !important;
                }';
            }
        }
    }
    if (!empty($inline_css)) {
        wp_add_inline_style('streamit-style', $inline_css);
    }
}
function streamit_sub_menu_color_options()
{
    $streamit_options = get_option('streamit_options');
    $inline_css = '';

    if (isset($streamit_options['streamit_header_variation'])  && $streamit_options['streamit_header_variation'] != '3') {
        if (isset($streamit_options['header_submenu_color_type']) && $streamit_options['header_submenu_color_type'] == 'custom') {
            if (isset($streamit_options['streamit_header_submenu_color']) && !empty($streamit_options['streamit_header_submenu_color'])) {
                $inline_css .= 'header .navbar ul li .sub-menu li a,header .navbar ul li .sub-menu li.current-menu-parent .sub-menu  li a, header .navbar ul li .sub-menu li:hover .sub-menu li a,header .navbar ul li .sub-menu li i,header .navbar ul li .sub-menu li.current-menu-parent .sub-menu  li i, header .navbar ul li .sub-menu li:hover .sub-menu li i,header .navbar ul li .sub-menu li:hover .sub-menu li a,header .navbar ul li .sub-menu li:hover .sub-menu li i{
                   color : ' . $streamit_options['streamit_header_submenu_color'] . ' !important;
               }';
            }

            if (isset($streamit_options['streamit_header_submenu_active_color']) && !empty($streamit_options['streamit_header_submenu_active_color'])) {
                $inline_css .= 'header .navbar ul li .sub-menu li.current-menu-item a,header .navbar ul li .sub-menu li.current-menu-item i,header .navbar ul li .sub-menu li.current-menu-ancestor a,header .navbar ul li .sub-menu li.current-menu-ancestor i,header .navbar ul li .sub-menu li.current-menu-parent .sub-menu li.current-menu-item  a,header .navbar ul li .sub-menu li.current-menu-parent .sub-menu li.current-menu-item  i
                   {
                       color : ' . $streamit_options['streamit_header_submenu_active_color'] . ' !important;
                   }';
            }

            if (isset($streamit_options['streamit_header_submenu_hover_color']) && !empty($streamit_options['streamit_header_submenu_hover_color'])) {
                $inline_css .= 'header .navbar ul li .sub-menu li:hover a,header .navbar ul li .sub-menu li:hover i,header .navbar ul li .sub-menu li.current-menu-parent:hover a, header .navbar ul li .sub-menu li.current-menu-parent .sub-menu li:hover a, header .navbar ul li .sub-menu li.current-menu-parent:hover .sub-menu li:hover a,header .navbar ul li .sub-menu li.current-menu-parent:hover i, header .navbar ul li .sub-menu li.current-menu-parent .sub-menu li:hover i, header .navbar ul li .sub-menu li.current-menu-parent:hover .sub-menu li:hover i,header .navbar ul li .sub-menu li:hover .sub-menu li:hover a,header .navbar ul li .sub-menu li:hover .sub-menu li:hover i{
                   color : ' . $streamit_options['streamit_header_submenu_hover_color'] . ' !important;
               }';
            }

            if (isset($streamit_options['streamit_header_submenu_background_color']) && !empty($streamit_options['streamit_header_submenu_background_color'])) {
                $inline_css .= 'header .navbar ul li .sub-menu li a,header .navbar ul li .sub-menu li.current-menu-parent li a,header .navbar ul li .sub-menu li.current-menu-parent:hover .sub-menu li a,header .navbar ul li .sub-menu li:hover .sub-menu li a,header .navbar ul li .sub-menu li:hover .sub-menu li a {
                   background : ' . $streamit_options['streamit_header_submenu_background_color'] . ' !important;
               }';
            }

            if (isset($streamit_options['header_submenu_background_hover_color']) && !empty($streamit_options['header_submenu_background_hover_color'])) {
                $inline_css .= 'header .navbar ul li .sub-menu li:hover a,header .navbar ul li .sub-menu li.current-menu-parent:hover a,header .navbar ul li .sub-menu li.current-menu-parent .sub-menu li:hover a,header .navbar ul li .sub-menu li.current-menu-parent:hover .sub-menu li:hover a,header .navbar ul li .sub-menu li:hover .sub-menu li:hover a{
                   background : ' . $streamit_options['header_submenu_background_hover_color'] . ' !important;
               }';
            }

            if (isset($streamit_options['header_submenu_background_active_color']) && !empty($streamit_options['header_submenu_background_active_color'])) {
                $inline_css .= 'header .navbar ul li .sub-menu li.current-menu-item a,header .navbar ul li .sub-menu li.current-menu-parent a,header .navbar ul li .sub-menu li.current-menu-parent .sub-menu li.current-menu-item  a {
                   background : ' . $streamit_options['header_submenu_background_active_color'] . ' !important;
               }';
            }
        }
    }
    if (!empty($inline_css)) {
        wp_add_inline_style('streamit-style', $inline_css);
    }
}

function streamit_responsive_menu_color_options()
{
    $streamit_options = get_option('streamit_options');
    $inline_css = '';

    if (isset($streamit_options['responsive_menu_button_type']) && $streamit_options['responsive_menu_button_type'] == 'custom') {
        if (isset($streamit_options['responsive_menu_button_color']) && !empty($streamit_options['responsive_menu_button_color'])) {
            $inline_css .= 'header .navbar-light .navbar-toggler{
                color : ' . $streamit_options['responsive_menu_button_color'] . ' !important;
            }';
            $inline_css .= 'header .menu-btn .line{
                background-color : ' . $streamit_options['responsive_menu_button_color'] . ' !important;
            }';
        }

        if (isset($streamit_options['responsive_menu_button_background_color']) && !empty($streamit_options['responsive_menu_button_background_color'])) {
            $inline_css .= 'header .navbar-light .navbar-toggler{
                background : ' . $streamit_options['responsive_menu_button_background_color'] . ' !important;
                border-color : ' . $streamit_options['responsive_menu_button_background_color'] . ' !important;
            }';
        }
        if (isset($streamit_options['responsive_menu_color']) && !empty($streamit_options['responsive_menu_color'])) {
            $inline_css .= '@media (max-width: 992px){
                header .navbar ul li a{
                    color : ' . $streamit_options['responsive_menu_color'] . ' !important;
                }
            }';
        }
        if (isset($streamit_options['responsive_menu_color']) && !empty($streamit_options['responsive_menu_color'])) {
            $inline_css .= '@media (max-width: 992px){
                header .navbar ul li a, header .navbar ul li i{
                    color : ' . $streamit_options['responsive_menu_color'] . ' !important;
                }
            }';
        }

        if (isset($streamit_options['responsive_menu_hover_color']) && !empty($streamit_options['responsive_menu_hover_color'])) {
            $inline_css .= '@media (max-width: 992px){
                header .navbar ul li:hover a,header .navbar ul li:hover i{
                    color : ' . $streamit_options['responsive_menu_hover_color'] . ' !important;
                }
            }';
        }
        if (isset($streamit_options['responsive_menu_hover_color']) && !empty($streamit_options['responsive_menu_hover_color'])) {
            $inline_css .= '@media (max-width: 992px){
                header .navbar ul li:hover a,header .navbar ul li:hover i,header .navbar ul li.current-menu-item a, header .navbar ul li.current-menu-parent a, header .navbar ul li.current-menu-parent i, header .navbar ul li.current-menu-item i,header .navbar ul li.current-menu-ancestor a,header .navbar ul li.current-menu-ancestor i{
                    color : ' . $streamit_options['responsive_menu_hover_color'] . ' !important;
                }
            }';
        }

        if (isset($streamit_options['responsive_menu_background_color']) && !empty($streamit_options['responsive_menu_background_color'])) {
            $inline_css .= '@media (max-width: 992px){
                header .navbar ul li a{
                    background : ' . $streamit_options['responsive_menu_background_color'] . ' !important;
                }
            }';
        }
        if (isset($streamit_options['responsive_menu_active_background_color']) && !empty($streamit_options['responsive_menu_active_background_color'])) {
            $inline_css .= '@media (max-width: 992px){
                header .navbar ul li.current-menu-item a, header .navbar ul li a:hover,
                header .navbar ul li:hover a,header .navbar ul li.current-menu-item a, header .navbar ul li.current-menu-parent a,   header .navbar ul li.current-menu-ancestor a{
                    background : ' . $streamit_options['responsive_menu_active_background_color'] . ' !important;
                }
            }';
        }
    }
    if (!empty($inline_css)) {
        wp_add_inline_style('streamit-style', $inline_css);
    }
}

function streamit_action_btn_color_options()
{
    $streamit_options = get_option('streamit_options');
    $inline_css = '';
    if (isset($streamit_options['header_display_button'])) {
        $options = $streamit_options['header_display_button'];
        if ($options == "no") {
            $inline_css .= '.sub-main .blue-btn.button{
                display : none !important;
                }';
        }
    }

    if (isset($streamit_options['header_button_color_type']) && $streamit_options['header_button_color_type'] == 'custom') {
        if (isset($streamit_options['streamit_download_btn_background']) && !empty($streamit_options['streamit_download_btn_background'])) {
            $inline_css .= 'header .navbar .sub-main .blue-btn.button,.responsive-vertical-logo-btn .sub-main .blue-btn.button{
                background : ' . $streamit_options['streamit_download_btn_background'] . ' !important;
            }';
        }

        if (isset($streamit_options['streamit_download_btn_background_hover']) && !empty($streamit_options['streamit_download_btn_background_hover'])) {
            $inline_css .= 'header .navbar .sub-main .blue-btn.button:hover,.responsive-vertical-logo-btn .sub-main .blue-btn.button:hover{
                background : ' . $streamit_options['streamit_download_btn_background_hover'] . ' !important;
            }';
        }

        if (isset($streamit_options['streamit_download_btn_text']) && !empty($streamit_options['streamit_download_btn_text'])) {
            $inline_css .= 'header .navbar .sub-main .blue-btn.button a,.responsive-vertical-logo-btn .sub-main .blue-btn.button a{
                color : ' . $streamit_options['streamit_download_btn_text'] . ' !important;
            }';
        }

        if (isset($streamit_options['streamit_download_btn_text_hover']) && !empty($streamit_options['streamit_download_btn_text_hover'])) {
            $inline_css .= 'header .navbar .sub-main .blue-btn.button:hover a,.responsive-vertical-logo-btn .sub-main .blue-btn.button:hover a{
                color : ' . $streamit_options['streamit_download_btn_text_hover'] . ' !important;
            }';
        }
    }
    if (!empty($inline_css)) {
        wp_add_inline_style('streamit-style', $inline_css);
    }
}
