<?php
/**
* Displays header widgets if assigned
*
* @package WordPress
* @subpackage streamit
* @since 1.0
* @version 1.0
*/
$streamit_options = get_option('streamit_options');
$has_sticky = '';

if(isset($streamit_options['sticky_header_display']) && $streamit_options['sticky_header_display'] == 'yes')
{
  $has_sticky = ' has-sticky';
}
?>
<header class="style-one<?php echo esc_attr($has_sticky,'streamit'); ?>" id="main-header">
      <?php
      if(isset($streamit_options['email_and_button']))
      {
        $options = $streamit_options['email_and_button'];
        if($options == "yes")
        {
        ?>
        <div class="container-fluid sub-header">
          <div class="row align-items-center">
            <div class="col-auto">
              <?php
              if(!empty($streamit_options['header_display_contact']))
              {
                $options = $streamit_options['header_display_contact'];
                if($options == "yes")
                {
              ?>
                  <div class="number-info">
                    <ul class="list-inline">
                        <?php
                        if(!empty($streamit_options['header_email']))
                        {
                        ?>
                        <li class="list-inline-item"><a href="mailto:<?php echo esc_html($streamit_options['header_email']); ?>">
                        <i class="fa fa-envelope"></i><?php echo esc_attr($streamit_options['header_email']); ?></a></li>
                        <?php } ?>
                        <?php if(!empty($streamit_options['header_phone']))
                        {
                        ?>
                        <li class="list-inline-item"><a href="tel:<?php echo str_replace(str_split('(),-" '), '',$streamit_options['header_phone']); ?>">
                        <i class="fa fa-phone"></i><?php echo esc_attr($streamit_options['header_phone']); ?></a></li>
                        <?php } ?>
                    </ul>
                  </div>

              <?php
                }
              }
              ?>
            </div>
            <div class="col-auto col-auto ml-auto sub-main">
              <?php
              $streamit_options = get_option('streamit_options');
              
              if(isset($streamit_options['streamit_header_social_media']))
              {
                $options = $streamit_options['streamit_header_social_media'];
                if($options == "yes"){ ?>
                  <div class="social-icone">
                    <?php $data = $streamit_options['social-media-iq']; ?>
                    
                    <ul class="list-inline">
                      <?php
                      foreach ($data as $key=>$options )
                      {
                        if($options) {
                          echo '<li class="d-inline"><a href="'.$options.'"><i class="fa fa-'.$key.'"></i></a></li>';
                        }
                      } ?>
                    </ul>
                  </div>
              <?php
                }
              }
              ?>
            </div>
          </div>
        </div>
        <?php
        }
      }
      ?>
      <div class="container-fluid"> <!--main-header class removed-->
        <div class="row align-items-center">
          <div class="col-sm-12">
            <nav class="navbar navbar-expand-lg navbar-light p-0">
            <?php
            if(isset($streamit_options['header_radio']) && $streamit_options['header_radio'] == 1)
            {
            ?>
             <a href="<?php  echo esc_url( home_url( '/' ) ); ?>">
             <?php
              if(!empty($streamit_options['header_text']))
              {
              ?>
              <h1 class="logo-text"><?php echo esc_attr($streamit_options['header_text']); ?></h1>
              <?php
              }
              ?>
             </a>
            <?php
            }
            else
            {
            ?>
               <a class="navbar-brand" href="<?php  echo esc_url( home_url( '/' ) ); ?>">
                <?php
                if(class_exists('ReduxFramework'))
                {
                  if(isset($streamit_options['streamit_logo']['url']))
                  {
                    $logo = $streamit_options['streamit_logo']['url'];
                  }
                  ?>
                  <img class="img-fluid logo" src="<?php echo esc_url($logo); ?>" alt="<?php  esc_attr_e( 'streamit', 'streamit' ); ?>">
                  <?php 
                }
                else
                {
                ?>
                  <img class="img-fluid logo" src="<?php echo get_template_directory_uri(); ?>/assets/images/logo.png" alt="<?php  esc_attr_e( 'streamit', 'streamit' ); ?>">
                <?php } ?>
              </a>
            <?php
            }
            ?>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                  <span class="navbar-toggler-icon">
                          <span class="menu-btn d-inline-block" id="menu-btn">
                            <span class="line"></span>
                            <span class="line"></span>
                            <span class="line"></span>
                         </span>
                  </span>
                </button>
              <div id="navbarSupportedContent" class="collapse navbar-collapse new-collapse">
                <?php if ( has_nav_menu( 'top' ) ) :
                     wp_nav_menu( array(
                        'theme_location' => 'top',
                        'menu_class'     => 'navbar-nav ml-auto',
                        'menu_id'        => 'top-menu',
                        'container'       => 'div',
                        'container_id'   => 'iq-menu-container',
                    ) );
                 endif; ?>
              </div>
              <div class="sub-main">
                <?php 
                  
                ?>
                  <nav aria-label="breadcrumb">
                    <?php get_template_part( 'template-parts/header/header', 'user' ); ?>

                  </nav>
                  
              </div>
            </nav>
            <div class="nav-overlay"></div>
          </div>
        </div>
      </div>
</header>