<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage streamit
 * @since 1.0
 * @version 1.0
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">

<head>
  <!-- Required meta tags -->
  <meta charset="<?php esc_attr(bloginfo('charset')); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <?php $streamit_options = get_option('streamit_options'); ?>

  <?php
  global $template;

  $c_url = explode('/', $template);
  $c_page = end($c_url);
  $class_hide = '';
  if ($c_page === 'single-movie.php' || $c_page === 'single-episode.php' || $c_page === 'single-video.php') {
    $class_hide = 'iq-hide-header';
  }
  if (!function_exists('has_site_icon') || !wp_site_icon()) {
    if (!empty($streamit_options['streamit_fevicon'])) { ?>
      <link rel="shortcut icon" href="<?php echo esc_url($streamit_options['streamit_fevicon']['url']); ?>" />
  <?php
    }
  }
  ?>

  <?php wp_head(); ?>
</head>

<?php
$bglayout = '';
if (class_exists('ReduxFramework')) {
  if (!empty($streamit_options['streamit_layout_image']['url']) && isset($streamit_options['streamit_layout_image']['url'])) {
    $bglayout = $streamit_options['streamit_layout_image']['url'];
  } else {
    $bglayout = '';
  }
}
?>

<body data-spy="scroll" data-offset="80" <?php body_class($class_hide); ?> <?php if (!empty($bglayout)) { ?> style="background-image: url(<?php echo esc_url($bglayout); ?> );" <?php } ?>>

  <?php wp_body_open(); ?>

  <?php
  if (isset($streamit_options['streamit_display_loader'])) {
    $options = $streamit_options['streamit_display_loader'];

    if ($options == "yes") {
  ?>
      <!-- loading -->
      <div id="loading">
        <div id="loading-center">
          <?php
          if (!empty($streamit_options['streamit_loader_gif']['url'])) {
            $bgurl = $streamit_options['streamit_loader_gif']['url'];
          ?>
            <img src="<?php echo esc_url($bgurl); ?>" alt="<?php esc_attr__('loader', 'streamit'); ?>">
          <?php
          } else {
            $bgurl = get_template_directory_uri() . '/assets/images/loader.gif';
          ?>
            <img src="<?php echo esc_url($bgurl); ?>" alt="<?php esc_attr__('loader', 'streamit'); ?>">
          <?php
          }
          ?>
        </div>
      </div>
      <!-- loading End -->
  <?php
    }
  }

  //--- class setting for vertical menu start---// 
  $default_site_content = '';
  if (class_exists('ReduxFramework')) {
    if (isset($streamit_options['streamit_header_variation']) && $streamit_options['streamit_header_variation'] !== 2)
      $default_site_content = 'streamit';
  }
  //--- class setting for vertical menu end---//
  ?>
  <div id="page" class="site <?php echo esc_attr($default_site_content, 'streamit'); ?>">

    <a class="skip-link screen-reader-text" href="#content"><?php esc_html__('Skip to content', 'streamit'); ?></a>
    <?php
    if (class_exists('ReduxFramework')) {
      $options = '';
      if (isset($streamit_options['streamit_header_variation'])) {
        $options = $streamit_options['streamit_header_variation'];
      }
      if ($options == "1") {
        get_template_part('template-parts/header/header', 'one');
      } else {
        get_template_part('template-parts/header/header', 'one');
      }
    } else {
      get_template_part('template-parts/header/header', 'one');
    }
    ?>
    <?php
    if ($c_page === 'single-tv_show.php') {
      $class_hide = 'hide-banner';
    }
    if ($c_page === '404.php') {
      $class_hide = 'hide-banner';
    }
    if ($class_hide === '') {
      streamit_display_header();
    }

    if (is_search() || is_page()) { ?>

      <div class="site-content-contain"> <?php

                                        } else { ?>

        <div class="site-content-contain"> <?php

                                          } ?>

        <div id="content" class="site-content">