<?php

namespace Elementor;

$html = '';
if (!defined('ABSPATH')) exit;
$settings = $this->get_settings();
$iq_option = get_option('streamit_options');
$terms_per_page = $settings['posts_per_page']['size'];
$current_page = (get_query_var('paged')) ? get_query_var('paged') : 1;
$offset = ($terms_per_page * $current_page) - $terms_per_page;
$options_streamit_load = $settings['pagination'];
$args = array();
$slider_title = '';
$view_cat = '';
$post_type = '';
$args = array(
   'post_type'         => array('tv_show', 'movie', 'video'),
   'post_status'       => 'publish',
   'order'    => $settings['order'],
);
if ($settings['slider_type'] == 'slider') {
   $args['paged'] = $current_page;
   $args['posts_per_page'] = -1;
} else {
   if ($terms_per_page == -1) {
      $args['paged'] = $current_page;
      $args['posts_per_page'] = -1;
   } else {
      $args['number']   = $terms_per_page;
      $args['offset']   = $offset;
   }
}

if (isset($settings['slider_title'])) {
   $slider_title = $settings['slider_title'];
   $slider_title_key  = str_replace(" ", "_", $slider_title);

   $title_option = 'm12iqt' . $slider_title_key;
   if (!get_option($title_option)) {
      update_option($title_option, $slider_title);
   }
   $view_title = $title_option;
}

if ($settings['iq_type'] == 'video') {
   $taxonomy = 'video_cat';
   $terms =  get_terms('video_cat', $args);
   $post_type = 'videos';
} else if ($settings['iq_type'] == 'tv_show') {
   $taxonomy = 'tv_show_genre';
   $terms =  get_terms('tv_show_genre', $args);
   $post_type = 'tv_shows';
} else {
   $taxonomy = 'movie_genre';
   $terms =  get_terms('movie_genre', $args);
   $post_type = 'movies';
}

$term_count = get_terms(array(
   'taxonomy' => $taxonomy,
   'fields'   => 'count',
));
if ($settings['slider_type'] == 'slider') {
   $align = 'favorites-slider';
} else {
   $align = 'favorites-grid';
}

$this->add_render_attribute('slider', 'data-nav', $settings['nav-arrow']);
$this->add_render_attribute('slider', 'data-items', $settings['desk_number']);
$this->add_render_attribute('slider', 'data-items-laptop', $settings['lap_number']);
$this->add_render_attribute('slider', 'data-items-tab', $settings['tab_number']);
$this->add_render_attribute('slider', 'data-items-mobile', $settings['mob_number']);
$this->add_render_attribute('slider', 'data-items-mobile-sm', $settings['mob_number']);
$this->add_render_attribute('slider', 'data-autoplay', $settings['autoplay']);
$this->add_render_attribute('slider', 'data-speed', $settings['speed']);
?>
<div class="iq_genres-contents favorites-contens <?php if ($settings['slider_type'] == 'grid') {
                                                      echo 'watchlist-contens';
                                                   } else {
                                                      echo 'iq-rtl-direction';
                                                   } ?> streamit_datapass_genres" data-options="<?php echo esc_html($options_streamit_load); ?>">
   <div class="iq-main-header d-flex align-items-center justify-content-between <?php if ($settings['slider_type'] == 'slider') {
                                                                                    echo 'iq-ltr-direction';
                                                                                 } ?>">
      <?php
      if (!empty($slider_title)) {
      ?>
         <h4 class="main-title"><?php echo esc_html($slider_title, "streamit-extensions"); ?></h4>
      <?php } ?>
   </div>
   <ul class="<?php echo esc_html($align, "streamit-extensions"); ?> movie-list-grid list-inline  row p-0 mb-0" <?php if ($settings['slider_type'] == 'slider') {
                                                                                                                     echo $this->get_render_attribute_string('slider');
                                                                                                                  } ?>>

      <?php
      if ($terms) {
         foreach ($terms as $term) {
            $args['category_name']  = $term->slug;
            $thumbnail_id = get_term_meta($term->term_id, 'thumbnail_id', true);
            if (!empty($thumbnail_id)) {
               $full_image =  wp_get_attachment_url($thumbnail_id);
            } else {
               $full_image =   IQ_TH_URL . '/assest/img/placeholder_genre.jpg';
            }
            if ($settings['slider_type'] == 'grid') {
               if ($settings['movie_grid_style'] == '1') {
                  $col = 'col-lg-12 col-md-4 col-sm-6 wl-child';
               }
               if ($settings['movie_grid_style'] == '2') {
                  $col = 'col-lg-6 col-md-4 col-sm-6 wl-child';
               }
               if ($settings['movie_grid_style'] == '3') {
                  $col = 'col-lg-4 col-md-4 col-sm-6 wl-child';
               }
               if ($settings['movie_grid_style'] == '4') {
                  $col = 'col-lg-3 col-md-4 col-sm-6 wl-child';
               }


      ?>
               <li class="slide-item <?php echo esc_attr($col); ?>">
                  <div class="block-images position-relative watchlist-img">
                     <div class="img-box">
                        <img src="<?php echo esc_url($full_image) ?>" class="img-fluid" alt="streamit">

                     </div>
                     <div class="block-description">
                        <h6 class="iq-title">
                           <?php
                           $view_list = substr($term->slug, 0, 3);
                           $view_cat =  $view_title . '=m12iq_' . $view_list;
                           update_option('m12iq_' . $view_list, $term->slug);
                           $view_all = '<a href="' . esc_url(get_page_link($iq_option['streamit_viewall_link'])) . '?' . $post_type . '=' .  esc_html($view_cat, "streamit-extensions") . '">' .  esc_html($term->name) . '</a>';
                           echo wp_kses_post($view_all);
                           ?>
                        </h6>
                     </div>
                  </div>
               </li>

            <?php } else {


            ?>

               <li class="slide-item">
                  <div class="block-images position-relative">
                     <div class="img-box">
                        <img src="<?php echo esc_url($full_image) ?>" class="img-fluid" alt="streamit">
                     </div>
                     <div class="block-description">
                        <h6 class="iq-title">
                           <?php
                           $view_list = substr($term->slug, 0, 3);
                           $view_cat =  $view_title . '=m12iq_' . $view_list;
                           $view_all = '<a href="' . esc_url(get_page_link($iq_option['streamit_viewall_link'])) . '?' . $post_type . '=' .  esc_html($view_cat, "streamit-extensions") . '">' .  esc_html($term->name) . '</a>';
                           echo wp_kses_post($view_all);
                           ?>
                        </h6>
                     </div>
                  </div>
               </li>
            <?php } ?>
      <?php }
      }
      ?>
   </ul>
   <?php
   if ($settings['slider_type'] == 'grid' && $settings['pagination'] == 'yes') {
      if ($terms_per_page > 1) {
         /** PAGINATION */
         $big = 999999999; // need an unlikely integer
         $pagination_args = array(
            'base' => str_replace($big, '%#%', get_pagenum_link($big)),
            'format' => '?paged=%#%',
            'current' => max(1, get_query_var('paged')),
            'total' => ceil($term_count / $terms_per_page),
            'prev_next'       => True,
            'prev_text'       => '<span aria-hidden="true">' . esc_html__('Previous page', 'streamit-extensions') . '</span>',
            'next_text'       => '<span aria-hidden="true">' . esc_html__('Next page', 'streamit-extensions') . '</span>',
            'type'            => 'list',
            'add_args'        => false,
            'add_fragment'    => ''
         );
         $paginate_links = paginate_links($pagination_args);
         if ($paginate_links) {
            echo '<div class="col-lg-12 col-md-12 col-sm-12">
                     <div class="pagination justify-content-center">
                                 <nav aria-label="Page navigation">';
            printf(esc_html__('%s', 'streamit-extensions'), $paginate_links);
            echo '</nav>
                         </div>
                     </div>';
         }
      }
   }
   if ($settings['slider_type'] == 'grid' && $settings['pagination'] == 'loadmore') {
      if ($terms_per_page > 1) {
         echo '<a class="streamit_loadmore_btn_' . $this->get_id() . ' btn btn-hover iq-button" tabindex="0" data-loading-text="' . $settings['loading_text'] . '">
                            <span>' . $settings['more_text'] . '</span>
                        </a>';
      }
   }
   if ($settings['slider_type'] == 'grid' && $settings['pagination'] == 'infinite') {
      if ($terms_per_page > 1) {
         echo '<div class="loader-wheel-container">                                                                   
         </div>';
      }
   }
   ?>
</div>
<?php if ($settings['slider_type'] == 'grid' && $settings['pagination'] == 'loadmore') { ?>
   <script>
      jQuery('.streamit_loadmore_btn_<?php echo $this->get_id() ?>').click(function() {
         let button = jQuery(this);
         let button_load = jQuery(this).attr('data-loading-text');
         let button_text = jQuery(this).text();
         let parentList = button.parent().find('.movie-list-grid');


         let data = {
            'action': 'loadmore_genres',
            'query': streamit_loadmore_params.posts, // that's how we get params from wp_localize_script() function
            'page': streamit_loadmore_params.current_page,
            'setting': <?php echo json_encode($this->get_settings()); ?>
         };

         jQuery.ajax({ // you can also use jQuery.post here
            url: streamit_loadmore_params.ajaxurl, // AJAX handler
            data: data,
            type: 'POST',
            beforeSend: function(xhr) {
               button.text(button_load); // change the button text, you can also add a preloader image
            },
            success: function(data) {
               if (data) {
                  button.text(button_text)
                  parentList.append(data); // insert new posts
                  streamit_loadmore_params.current_page++;

                  if (streamit_loadmore_params.current_page == streamit_loadmore_params.max_page) {
                     button.remove(); // if last page, remove the button
                  }

               } else {
                  button.remove(); // if no data, remove the button as well
               }
            }
         });
      });
   </script>
<?php } ?>
<?php if ($settings['slider_type'] == 'grid' && $settings['pagination'] == 'infinite') { ?>
   <script>
      jQuery(function(jQuery) {
         var canBeLoaded = true,
            bottomOffset = 2000; // the distance (in px) from the page bottom when you want to load more posts

         var streamit_options = jQuery('.streamit_datapass_genres').data('options');
         if (streamit_options == "infinite") {
            jQuery(window).scroll(function() {
               let button = jQuery(this);
               let parentList = button.parent().find('.movie-list-grid');

               //** search load more *//
               let data = {
                  'action': 'loadmore_genres',
                  'query': streamit_loadmore_params.posts,
                  'page': streamit_loadmore_params.current_page,
                  'setting': <?php echo json_encode($this->get_settings()); ?>
               };

               if (jQuery(document).scrollTop() > (jQuery(document).height() - bottomOffset) && canBeLoaded == true) {

                  jQuery.ajax({
                     url: streamit_loadmore_params.ajaxurl,
                     data: data,
                     type: 'POST',
                     beforeSend: function(xhr) {
                        canBeLoaded = false;
                     },
                     success: function(data) {
                        if (data) {
                           jQuery(".loader-wheel-container").html('<div class="loader-wheel"><i><i><i><i><i><i><i><i><i><i><i><i></i></i></i></i></i></i></i></i></i></i></i></i></div>');
                           jQuery('.favorites-contens').find('.movie-list-grid').append(data); // where to insert posts
                           canBeLoaded = true; // the ajax is completed, now we can run it again
                           streamit_loadmore_params.current_page++;
                        } else {
                           jQuery(".loader-wheel-container").html('');
                        }

                     }
                  });
               }


            });

         } else {
            //nothing to call
         }
      });
   </script>
<?php } ?>