<?php

namespace Elementor;
$this->add_control(
    'desk_number',
    [
        'label' => __('Desktop view', 'iqonic'),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
            'active' => true,
        ],

        'label_block' => true,
        'default' => '4',
    ]
);

$this->add_control(
    'lap_number',
    [
        'label' => __('Laptop view', 'iqonic'),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
            'active' => true,
        ],

        'label_block' => true,
        'default' => '2',
    ]
);

$this->add_control(
    'tab_number',
    [
        'label' => __('Tablet view', 'iqonic'),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
            'active' => true,
        ],

        'label_block' => true,
        'default' => '2',
    ]
);

$this->add_control(
    'mob_number',
    [
        'label' => __('Mobile view', 'iqonic'),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
            'active' => true,
        ],

        'label_block' => true,
        'default' => '2',
    ]
);

$this->add_control(
    'autoplay',
    [
        'label' => __('Autoplay', 'iqonic'),
        'type' => Controls_Manager::SELECT,
        'default' => 'true',
        'options' => [
            'true' => __('True', 'iqonic'),
            'false' => __('False', 'iqonic'),

        ],

    ]
);

$this->add_control(
    'speed',
    [
        'label' => __('Speed', 'iqonic'),
        'type' => Controls_Manager::TEXT,
        'label_block' => true,
        'default' => '300',
    ]
);

$this->add_control(
    'nav-arrow',
    [
        'label' => __('Arrow', 'iqonic'),
        'type' => Controls_Manager::SELECT,
        'default' => 'true',
        'options' => [
            'true' => __('True', 'iqonic'),
            'false' => __('False', 'iqonic'),

        ],

    ]
);


$this->add_control(
    'arrow_back_normal_color',
    [
        'label' => __('Arrow Background Color', 'iqonic'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .favorites-slider .slick-arrow i,{{WRAPPER}} .inner-slider .slick-arrow i,{{WRAPPER}} .trending-slider-nav .slick-arrow i,{{WRAPPER}} .trending-contens .slick-arrow i,{{WRAPPER}} .favorites-slider .slick-arrow svg,{{WRAPPER}} .inner-slider .slick-arrow svg,{{WRAPPER}} .trending-slider-nav .slick-arrow svg,{{WRAPPER}} .trending-contens .slick-arrow svg' => 'background: {{VALUE}};',

        ],
    ]
);

$this->add_control(
    'icon_color',
    [
        'label' => __('Icon Color', 'iqonic'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .favorites-slider .slick-arrow i,{{WRAPPER}} .inner-slider .slick-arrow i,{{WRAPPER}} .trending-slider-nav .slick-arrow i,{{WRAPPER}} .trending-contens .slick-arrow i,{{WRAPPER}} .favorites-slider .slick-arrow svg,{{WRAPPER}} .inner-slider .slick-arrow svg,{{WRAPPER}} .trending-slider-nav .slick-arrow svg,{{WRAPPER}} .trending-contens .slick-arrow svg' => 'color: {{VALUE}};',

        ],
    ]
);

