
jQuery(document).ready(function() {

    window.$ = jQuery ;

    //selected index from video/movie result 
    window.selected = [] ;

    //search result
    window.reponsedata = [];

    // remove wordpress notification
    jQuery('.notice').remove();

    // helper function for array remove key value based on index
    Array.prototype.remove = function() {
        var what, a = arguments, L = a.length, ax;
        while (L && this.length) {
            what = a[--L];
            while ((ax = this.indexOf(what)) !== -1) {
                this.splice(ax, 1);
            }
        }
        return this;
    };

    // streamit import button
    jQuery('#streamit-import-btn').click( function() {

        var selectedData = [] ;
        var currentElement  = jQuery(this) ;
        var selected_option = jQuery('#streamit-import-type').val();
        var contentType = '' ;

        removeNotiFication();

        // row selected validation
        if((selected.length === undefined || selected.length === 0) && selected_option !== 'csv_import' ) {
            jQuery('#streamit-data-select-warn').removeClass('d-none');
            return 0 ;
        } else {
            jQuery('#streamit-data-select-warn').addClass('d-none');
            var temp = [] ;
            selected.forEach(function(currentValue, index, arr){
                temp.push(reponsedata[parseInt(currentValue)]);
            });
            selectedData = temp ;
        }

        currentElement.attr('disabled', true);
        currentElement.html('<b> Importing... </b>');

        if(selected_option !== '' && selected_option !== null ) {
            contentType = selected_option.split('_');
        }

        if(selected_option === 'csv_import') {

            var atachment_id = jQuery('#myprefix_image_id').val();
            var import_content_type = jQuery('#streamit-content-csv-import-type').val();
            var content = import_content_type.split('_');

            jQuery.ajax({
                url: streamit_localize.ajaxurl,
                type: "post",
                data: {
                    action: 'streamit_ajax',
                    _ajax_nonce: streamit_localize.nonce,
                    streamit_route: 'import_from_youtube',
                    provider: 'csv',
                    content_type: content[0],
                    attachment_id: atachment_id,
                    data: selectedData
                },
                success: function(response) {
                    $('checkbox').prop('checked', false);
                    selected = [] ;
                    var importButtonElement = jQuery('#streamit-import-btn') ;
                    importButtonElement.attr('disabled', false);
                    importButtonElement.html('Import');
                    jQuery('#streamit-data-success').removeClass('d-none');
                }
            });

        }
        else if(selected_option === 'movie_tmdb'){

            //console.log(contentType[0]);
            jQuery.ajax({
                url: streamit_localize.ajaxurl,
                type: "post",
                data: {
                    action: 'streamit_ajax',
                    _ajax_nonce: streamit_localize.nonce,
                    streamit_route: 'import_from_youtube',
                    provider: contentType[1],
                    content_type: contentType[0],
                    data: selectedData
                },
                success: function(response) {
                    $('checkbox').prop('checked', false);
                    selected = [] ;
                    var importButtonElement = jQuery('#streamit-import-btn') ;
                    importButtonElement.attr('disabled', false);
                    importButtonElement.html('Import');
                    jQuery('#streamit-data-success').removeClass('d-none');
                }
            });

        }
        else  {

            jQuery.ajax({
                url: streamit_localize.ajaxurl,
                type: "post",
                data: {
                    action: 'streamit_ajax',
                    _ajax_nonce: streamit_localize.nonce,
                    streamit_route: 'import_from_youtube',
                    provider: contentType[1],
                    content_type: contentType[0],
                    data: selectedData
                },
                success: function(response) {
                    $('checkbox').prop('checked', false);
                    selected = [] ;
                    var importButtonElement = jQuery('#streamit-import-btn') ;
                    importButtonElement.attr('disabled', false);
                    importButtonElement.html('Import');
                    jQuery('#streamit-data-success').removeClass('d-none');
                }
            });
        }

    });

    // handle check-all
    jQuery('#streamit-import-check-all').change(function() {

       var isChacked = jQuery(this).is(':checked') ;

       if (isChacked) {
           jQuery('.form-check-input').prop('checked', true);

           $('.youtube-video-id').each(function (index) {
               selected.push($(this).attr('data-index'));
           });

           var dataIndex =  jQuery('.youtube-video-id').attr('data-index');
       } else {
            selected = [];
            jQuery('.form-check-input').prop('checked', false);
       }

    });

    // handle single check/uncheck of video list
    jQuery(document).on( 'change', '.form-check-input', function() {

        var currentElement = jQuery(this) ;
        var isChacked =  currentElement.is(':checked');
        var indexValue = currentElement.attr('data-index');

        if(indexValue !== undefined) {
            var position = '' ;
            if (selected.length !== undefined) {
                position = selected.indexOf(indexValue);
                if (isChacked) {
                    selected.push(indexValue);
                } else {
                    selected.remove(indexValue);
                }
            }
        }

    });

    // Tab handle changes
    jQuery('#myTab a').on('click', function (e) {
        jQuery(this).tab('show')
    });

    // handle null stremait developer key
    jQuery('.developer-key-input').keyup( function() {
        var currentElement = $(this) ;
        var provider = currentElement.attr('data-type');
        var value =  currentElement.val() ;
        if(value === null || value === '') {
            jQuery('#' + provider + '-checkbox').prop('checked', false);
        }
    });

    // handle streamit csv upload
    jQuery('#streamit-file-upload').click(function() {

        var image_frame;
        
        if(image_frame){
            image_frame.open();
        }

        // Define image_frame as wp.media object
        image_frame = 

        wp.media(
            {
                title: 'Select Media',
                multiple : false,
                library : {
                    type : 'text/csv'
                }
            }
        );

        image_frame.on('close',function() {

            // On close, get selections and save to the hidden input
            // plus other AJAX stuff to refresh the image preview
            var selection =  image_frame.state().get('selection');
            var gallery_ids = new Array();
            var my_index = 0;
            selection.each(function(attachment) {
            gallery_ids[my_index] = attachment['id'];
            my_index++;
            });
            var ids = gallery_ids.join(",");

            readDataFromAttachmentCsv(ids);

            Refresh_Image(ids);
        });

        image_frame.on('open',function() {
        // On open, get the id from the hidden input
        // and select the appropiate images in the media manager
        var selection =  image_frame.state().get('selection');
        var ids = jQuery('input#myprefix_image_id').val().split(',');
        ids.forEach(function(id) {
            var attachment = wp.media.attachment(id);
            attachment.fetch();
            selection.add( attachment ? [ attachment ] : [] );
        });

        });

        image_frame.open();

        jQuery('#streamit-search-btn').addClass('d-none');

    });

    // Read data from csv file
    function readDataFromAttachmentCsv (id) {
        jQuery.ajax({
            url: streamit_localize.ajaxurl,
            type: "post",
            data: {
                action: 'streamit_ajax',
                _ajax_nonce: streamit_localize.nonce,
                streamit_route: 'read_data_from_csv',
                attachment: id,
            },
            success: function(response) {

                jQuery('#streamit-data-csv-read-fail-warning').addClass('d-none');
                
                if(typeof response !== 'Object'){
                    jQuery('#streamit-data-csv-read-fail-warning').removeClass('d-none');
                    return true;
                }

                var csvResponse = response;
                var data = csvResponse.data ;

                reponsedata = [] ;
                reponsedata = data

                console.log('sadadas == ', data);

                jQuery('#streamit-data-search-result tbody').empty();
                jQuery('#streamit-data-search-result tfoot').empty();

                if(data.length !== undefined && data.length > 0 ) {

                    data.forEach(function(currentValue, index, arr) {
                        let td = '' ;
                        let video_detail = currentValue ;
                        td += '<td> <input type="checkbox" class="form-check-input" data-index="'+ index +'"  id="form-check-input-' + index +'"  > </td>' ;
                        td += '<td> <img style="max-height:150px; max-width:150px" src="https://www.believemusic.com/wp-content/uploads/2017/05/live.jpg"> </td>' ;
                        td += '<td> ' + currentValue[0] + ' </td> ' ;
                        td += '<td> ' + currentValue[0] + ' </td> ' ;
                        jQuery('#streamit-data-search-result tbody').append('<tr> ' + td + ' </tr>');
                    });

                }

            }

        });

    }

    jQuery('#streamit-csv-upload-btn').click(function () {

        var atachment_id = jQuery('#myprefix_image_id').val();
        jQuery.ajax({
            url: streamit_localize.ajaxurl,
            type: "post",
            data: {
                action: 'streamit_ajax',
                _ajax_nonce: streamit_localize.nonce,
                streamit_route: 'import_from_youtube',
                provider: 'csv',
                content_type: 'movie',
                attachment_id: atachment_id
            },
            success: function(response) {
            }
        });

    });

    // Ajax request to refresh the image preview
    function Refresh_Image(the_id){
        var data = {
            action: 'myprefix_get_image',
            id: the_id
        };

        jQuery.get(ajaxurl, data, function(response) {
            if(response.success === true) {
                jQuery('#myprefix-preview-image').replaceWith( response.data.image );
            }
        });
    }

    // handle import type change
    jQuery('#streamit-import-type').change( function() {

        var selected_val = jQuery(this).val();

        if( selected_val === 'csv_import') {
            
            jQuery('#streamit-csv-import-section').removeClass('d-none') ;
            jQuery('#search-keyword-section').addClass('d-none') ;
            jQuery('#streamit-file-upload').removeClass('d-none') ;
            jQuery('#streamit-csv-upload-btn').removeClass('d-none') ;
            jQuery('#streamit-search-btn').addClass('d-none');
            jQuery('#streamit-csv-type').removeClass('d-none') ;
            jQuery('#streamit-demo-movie-csv-download').removeClass('d-none');
            jQuery('#youtube-channel-section').addClass('d-none') ;

        } else if( selected_val === 'video_youtube_playlist' ) {
        
            jQuery('#youtube-channel-section').removeClass('d-none') ;
            jQuery('#search-keyword-section').addClass('d-none') ;
            jQuery('#streamit-demo-movie-csv-download').addClass('d-none');
            jQuery('#streamit-csv-import-section').addClass('d-none') ;
            jQuery('#streamit-file-upload').addClass('d-none') ;
            jQuery('#streamit-csv-upload-btn').addClass('d-none') ;
            jQuery('#streamit-search-btn').removeClass('d-none');
            jQuery('#streamit-demo-movie-csv-download').addClass('d-none');
            jQuery('#streamit-csv-type').addClass('d-none') ;

        }else if( selected_val === 'movie_tmdb' ){
            jQuery('#streamit-data-search-result').find('tr:first').next().find('th:last').text('Description');
        }else {

            jQuery('#streamit-csv-import-section').addClass('d-none') ;
            jQuery('#search-keyword-section').removeClass('d-none') ;
            jQuery('#streamit-file-upload').addClass('d-none') ;
            jQuery('#streamit-csv-upload-btn').addClass('d-none') ;
            jQuery('#streamit-search-btn').removeClass('d-none');
            jQuery('#streamit-demo-movie-csv-download').addClass('d-none');
            jQuery('#streamit-csv-type').addClass('d-none') ;
            jQuery('#youtube-channel-section').addClass('d-none')  ;

        }

        // if( selected_val === 'video_youtube_playlist' ) {
        //     jQuery('#youtube-channel-section').removeClass('d-none') ;
        //     jQuery('#search-keyword-section').addClass('d-none') ;
        // } else {
        //     jQuery('#youtube-channel-section').addClass('d-none')  ;
        //     jQuery('#search-keyword-section').removeClass('d-none') ;
        // }

    });

    jQuery('#streamit-content-csv-import-type').change(function (){
        var currentElement  = jQuery(this) ;
        var currentValue = currentElement.val() ;
        if(currentValue === 'video_import') {
            jQuery('.streamit-demo-movie-csv').addClass('d-none');
            jQuery('.streamit-demo-video-csv').removeClass('d-none');
        } else {
            jQuery('.streamit-demo-movie-csv').removeClass('d-none');
            jQuery('.streamit-demo-video-csv').addClass('d-none');
        }
    });

    // handle search btn click
    jQuery('#streamit-search-btn').click( function() {

        // clear notification
        removeNotiFication();

        var selected_option = jQuery('#streamit-import-type').val();

        if(selected_option !== '' && selected_option !== null ) {
            var searchValue = selected_option.split('_');
        }

        var search_key = '' ;

        if (selected_option === 'video_youtube_playlist') {
            search_key = jQuery('#stremit-youtube-channel-search').val();
        } else {
            search_key = jQuery('#stremit-search').val();
        }

        var limit = jQuery('#streamit-result-limit').val();

        // get data selected key data
        getThirdPartyData(selected_option, search_key, limit);

    });

    // handle api key save
    jQuery('.key-save-btn').click(function() {

        var type             = jQuery(this).attr('data-type');
        var developer_key    = jQuery('#' + type + '-developer-key').val();
        var isChacked        = jQuery('#' + type + '-checkbox').is(':checked') ;
        var status           = 'off' ; 

        if (isChacked) {
            status  = 'on'
        }

        saveDeveloperKey(type, developer_key, status);

    });

    // save developer functions
    function saveDeveloperKey (type, developer_key, status) {

        jQuery.ajax({
            url: streamit_localize.ajaxurl,
            type: "post",
            data: {
                action: 'streamit_ajax',
                _ajax_nonce: streamit_localize.nonce,
                streamit_route: 'save_developer_key_function',
                type: type,
                key: developer_key,
                status: status
            },
            success: function(response) {
                jQuery('#streamit-developer-key-success').removeClass('d-none');
                setTimeout(function(){ 
                    location.reload();                    
                }, 500);
            }
        });

    }

    // handle third-party api data
    function getThirdPartyData (search_type, search_key, limit) {

        if(search_type !== '') {

            var dataLoaderTr = jQuery('#streamit-data-loader');
            var noDataTr = jQuery('#streamit-no-data-tr');
            dataLoaderTr.removeClass('d-none');
            noDataTr.addClass('d-none');
    
            // streamit get data from third-party platform
            if(search_type === 'video_youtube' || search_type === 'movie_youtube' ) {

                var channel = '' ;

                var youTubeDeveloperKey = streamit_localize.youtube ;

                jQuery.ajax({
                    url: 'https://www.googleapis.com/youtube/v3/search?part=snippet&maxResults='+ limit + '&q=' + search_key + '&key=' + youTubeDeveloperKey ,
                    type: "GET",
                    crossDomain: true,
                    dataType: 'jsonp',
                    data: {},
                    success: function(response, textStatus, jqXHR) {

                        if(response.error !== undefined) {
                            jQuery('#youtube-free-quota-limit').removeClass('d-none');
                            jQuery('#youtube-free-quota-limit-message').html(response.error.message);
                            dataLoaderTr.addClass('d-none');
                            noDataTr.removeClass('d-none');
                            return 0 ;
                        }

                        let youtube_response  =  response.items;
                        reponsedata = [] ;
                        reponsedata = youtube_response ;

                        jQuery('#streamit-data-search-result tbody').empty();
                        jQuery('#streamit-data-search-result tfoot').empty();

                        if(youtube_response.length > 0) {
                            dataLoaderTr.removeClass('d-none');
                            youtube_response.forEach(function(currentValue, index, arr){
                                let td = '' ;
                                let video_detail = currentValue.snippet;
                                td += '<td> <input type="checkbox" class="form-check-input" data-index="'+ index +'"  id="form-check-input-' + index +'"  > </td>' ;
                                td += '<td> <img src="'+ video_detail.thumbnails.default.url +'"> </td>';
                                td += '<td>'+ video_detail.title + ' <input type="hidden" class="youtube-title" name="title[]" value="' + video_detail.title + '" > <input type="hidden" data-index="' + index + '" class="youtube-video-id" name="video_id[]" value="' + currentValue.id.videoId + '" > </td>';
                                td += '<td>'+ video_detail.channelTitle +'</td>';
                                jQuery('#streamit-data-search-result tbody').append('<tr> ' + td + ' </tr>');
                            });
                        } else {
                            dataLoaderTr.addClass('d-none');
                            noDataTr.removeClass('d-none');
                        }

                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown){
                        dataLoaderTr.addClass('d-none');
                        noDataTr.removeClass('d-none');
                    }
                });

            } else if (search_type === 'video_youtube_playlist') {

                var channel = '' ;
                var youTubeDeveloperKey = streamit_localize.youtube ;
                jQuery.ajax({
                    url: 'https://youtube.googleapis.com/youtube/v3/playlists?maxResults='+ limit +'&part=snippet%2CcontentDetails&channelId='+ search_key +'&key=' + youTubeDeveloperKey ,
                    type: "GET",
                    crossDomain: true,
                    dataType: 'jsonp',
                    data: {},
                    success: function(response, textStatus, jqXHR) {
                        let youtube_response  =  response.items;
                        reponsedata = [] ;
                        reponsedata = youtube_response ;

                        jQuery('#streamit-data-search-result tbody').empty();
                        jQuery('#streamit-data-search-result tfoot').empty();

                        if(youtube_response.length > 0) {

                            dataLoaderTr.removeClass('d-none');
                            youtube_response.forEach(function(currentValue, index, arr){
                                let td = '' ;
                                let video_detail = currentValue.snippet;
                                td += '<td> <input type="checkbox" class="form-check-input" data-index="'+ index +'"  id="form-check-input-' + index +'"  > </td>' ;
                                td += '<td> <img src="'+ video_detail.thumbnails.default.url +'"> </td>';
                                td += '<td>'+ video_detail.title + '  (' + currentValue.contentDetails.itemCount + ' videos ) '  + ' <input type="hidden" class="youtube-title" name="title[]" value="' + video_detail.title + '" > <input type="hidden" data-index="' + index + '" class="youtube-video-id" name="video_id[]" value="' + currentValue.id.videoId + '" > </td>';
                                td += '<td>'+ video_detail.channelTitle +'</td>';
                                jQuery('#streamit-data-search-result tbody').append('<tr> ' + td + ' </tr>');
                            });

                        } else {
                            dataLoaderTr.addClass('d-none');
                            noDataTr.removeClass('d-none');
                        }

                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown){
                        dataLoaderTr.addClass('d-none');
                        noDataTr.removeClass('d-none');
                    }
                });

            } else if (search_type === 'video_vimeo') {

                var vimeoDeveloperKey = streamit_localize.vimeo ;

                jQuery.ajax({
                    url: 'https://api.vimeo.com/videos?query="'+ search_key + '"&per_page='+ limit +'&page=1',
                    type: "GET",
                    crossDomain: true,
                    dataType: 'json',
                    headers: {
                        "Authorization": 'Bearer ' + vimeoDeveloperKey
                    },
                    data: {},
                    success: function(response, textStatus, jqXHR) {

                        let vimeo_response  =  response.data;

                        reponsedata = [] ;
                        reponsedata = vimeo_response ;

                        jQuery('#streamit-data-search-result tbody').empty();

                        if(vimeo_response.length > 0) {

                            dataLoaderTr.removeClass('d-none');

                            jQuery('#no-data-tr').remove();
                            vimeo_response.forEach(function(currentValue, index, arr) {
                                let td = '' ;
                                let video_detail = currentValue;
                                td += '<td> <input type="checkbox" class="form-check-input" data-index="'+ index +'"  id="form-check-input-' + index +'" > </td>' ;
                                td += '<td> <img src="'+ video_detail.pictures.sizes[1].link +'"> </img> </td>';
                                td += '<td>'+ video_detail.name +'</td>';
                                td += '<td>'+ video_detail.user.name +'</td>';
                                jQuery('#streamit-data-search-result').append('<tr> ' + td + ' </tr>');
                            });
                        } else {

                            dataLoaderTr.addClass('d-none');
                            noDataTr.removeClass('d-none');

                        }

                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown){
                        dataLoaderTr.addClass('d-none');
                        noDataTr.removeClass('d-none');
                    }
                });

            } else if (search_type === 'movie_imdb') {
            }
            else if(search_type === 'movie_tmdb' ) {

                var channel = '' ;

                var tmdbKey = streamit_localize.tmdb;


                jQuery.ajax({
                    url: 'https://api.themoviedb.org/3/search/movie?api_key=' + tmdbKey + '&language=en-US&query=' + search_key + '&page=1&include_adult=false',
                    type: "GET",
                    crossDomain: true,
                    dataType: 'jsonp',
                    data: {},
                    success: function(response, textStatus, jqXHR) {

                        let tmdb_response  =  response.results
                        reponsedata = [] ;
                        reponsedata = tmdb_response ;

                        jQuery('#streamit-data-search-result tbody').empty();
                        jQuery('#streamit-data-search-result tfoot').empty();

                        if(tmdb_response.length > 0) {
                            dataLoaderTr.removeClass('d-none');
                            tmdb_response.forEach(function(currentValue, index, arr){
                                let td = '' ;
                                td += '<td> <input type="checkbox" class="form-check-input" data-index="'+ index +'"  id="form-check-input-' + index +'"  > </td>' ;
                                td += '<td> <img src="http://image.tmdb.org/t/p/w500/'+ currentValue.poster_path +'" style="object-fit: cover; height: 100px;"> </td>';
                                td += '<td>'+ currentValue.title + ' <input type="hidden" class="youtube-title" name="title[]" value="' + currentValue.title + '" > ' +
                                    '<input type="hidden" data-index="' + index + '" class="youtube-video-id" name="video_id[]" value="' + currentValue.id + '" > </td>';
                                td += '<td>'+ currentValue.overview +'</td>';
                                jQuery('#streamit-data-search-result tbody').append('<tr> ' + td + ' </tr>');
                            });
                        } else {
                            dataLoaderTr.addClass('d-none');
                            noDataTr.removeClass('d-none');
                        }

                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown){
                        dataLoaderTr.addClass('d-none');
                        noDataTr.removeClass('d-none');
                    }
                });

            }
            else if (search_type === 'movie_omdb' || search_type === 'movie_omdb' ) {

                type = search_type.split('_');
                var omdbDeveloperKey = streamit_localize.omdb ;

                jQuery.ajax({
                    url: 'https://www.omdbapi.com/?apikey='+ omdbDeveloperKey +'&type=' + type[0] + '&s=' + search_key,
                    contentType: 'application/json',
                    type: "GET",
                    crossDomain: true,
                    dataType: 'jsonp',
                    data: {},
                    success: function(data, textStatus, jqXHR){

                        if(data.Response  === 'True') {

                            let omdb_response  =  data.Search;

                            reponsedata = [] ;
                            reponsedata = omdb_response ;

                            jQuery('#streamit-data-search-result tbody').empty();
                            jQuery('#streamit-data-search-result tfoot').empty();

                            if(omdb_response.length > 0) {

                                dataLoaderTr.removeClass('d-none');
                                
                                omdb_response.forEach( function(currentValue, index, arr) {
                                    let td = '' ;
                                    let video_detail = currentValue ;
                                    td += '<td> <input type="checkbox" class="form-check-input" data-index="'+ index +'"  id="form-check-input-' + index +'"  > </td>' ;
                                    td += '<td> <img style="max-height:150px" src="'+ video_detail.Poster +'"> </td>';
                                    td += '<td>'+ video_detail.Title + '  (  '+ video_detail.Year + ' ) ' + ' </td>';
                                    td += '<td> - </td>';
                                    jQuery('#streamit-data-search-result tbody').append('<tr> ' + td + ' </tr>');
                                });

                            }

                        } else {

                            dataLoaderTr.addClass('d-none');
                            noDataTr.removeClass('d-none');

                        }

                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown){
                        dataLoaderTr.addClass('d-none');
                        noDataTr.removeClass('d-none');
                    }
                });

            }

        }

    }

    // clear all notification helper function
    function removeNotiFication () {
        jQuery('#streamit-data-select-warn').addClass('d-none');
        jQuery('#streamit-data-success').addClass('d-none');
    }

});


