<?php

Class ClassStreamitDataImport {

    public function saveDeveloperKey () {

        if(isset($_POST['key']) && isset($_POST['type'])) {

            $success = update_option('streamit_'. $_POST['type'] . '_auth', $_POST['key']);
            $status  = update_option('streamit_'. $_POST['type'] . '_status', $_POST['status']);

            if($success) {
                echo json_encode(array('status' => true, 'message' => $_POST['type'] . ' API Key updated successfully.' )); die;
            } else {
                echo json_encode(array('status' => false, 'message' => $_POST['type'] .  ' API Key not updated successfully.', )); die;
            }
        }

    }

    function importUrlToMedia($url, $id) {
        $temp_file = download_url( $url, 10 );

        if ( !is_wp_error( $temp_file ) ) {
            $wp_file_type = wp_check_filetype($temp_file);;
            $file = array(
                'name'     => basename($url),
                'type'     => $wp_file_type['type'],
                'tmp_name' => $temp_file,
                'error'    => 0,
                'size'     => filesize($temp_file),
            );

            $overrides = array(
                'test_form' => false,
                'test_size' => true,
            );

            return media_handle_sideload( $file, $id, NULL, $overrides );
        }
    }


    public function importFromYouTube () {

        try {

            if (isset($_POST['provider']) && $_POST['provider'] === 'youtube') {

                foreach ($_POST['data'] as $key => $value) {

                    $id = wp_insert_post(array(
                        'post_title'    => $value['snippet']['title'],
                        'post_type'     => $_POST['content_type'],
                        'post_content'  => $value['snippet']['description'],
                        'post_status'   => 'publish'
                    ));

                    $thumbnail_post_id = $this->importUrlToMedia($value['snippet']['thumbnails']['medium']['url'], $id);

                    
                    if ($_POST['content_type'] === 'movie') {
                        add_post_meta( $id, '_' . $_POST['content_type'] . '_release_date' ,  current_time('timestamp') );
                        add_post_meta( $id, '_' . $_POST['content_type'] . '_censor_rating' ,  '0.0' );
                        add_post_meta( $id, '_' . $_POST['content_type'] . '_run_time' ,  '0 hr : 0 min' );
                        add_post_meta( $id, '_imdb_id' ,  '0.0' );
                    }

                    add_post_meta( $id, '_thumbnail_id' , $thumbnail_post_id );
                    add_post_meta( $id, '_' . $_POST['content_type'] . '_choice' , $_POST['content_type'] . '_embed' );
                    add_post_meta( $id, '_' . $_POST['content_type'] . '_embed_content' , '<iframe width="1024" height="574" src="https://www.youtube.com/embed/' . $value['id']['videoId'] . '" allowfullscreen ></iframe>' );
        
                }

            } elseif (isset($_POST['provider']) && $_POST['provider'] === 'vimeo') {

                foreach ($_POST['data'] as $key => $value) {

                    $id = wp_insert_post(array(
                        'post_title'    => $value['name'],
                        'post_type'     => $_POST['content_type'],
                        'post_content'  => $value['description'],
                        'post_status'   => 'publish'
                    ));

                    $position = strpos($value['pictures']['sizes'][8]['link'], "?");

                    $img_url = substr($value['pictures']['sizes'][8]['link'], 0, $position);
                
                    $thumbnail_post_id = $this->importUrlToMedia($img_url, $id);

                    if ($_POST['content_type'] === 'movie') {
                        add_post_meta( $id, '_' . $_POST['content_type'] . '_release_date' ,  current_time('timestamp') );
                        add_post_meta( $id, '_' . $_POST['content_type'] . '_censor_rating' ,  '0.0' );
                        add_post_meta( $id, '_' . $_POST['content_type'] . '_run_time' ,  '0 hr : 0 min' );
                        add_post_meta( $id, '_imdb_id' ,  '0.0' );
                    }

                    add_post_meta( $id, '_thumbnail_id' , $thumbnail_post_id );
                    add_post_meta( $id, '_' . $_POST['content_type'] . '_choice' , $_POST['content_type'] . '_embed' );
                    add_post_meta( $id, '_' . $_POST['content_type'] . '_embed_content' , $value['embed']['html'] );

                }

            } elseif (isset($_POST['provider']) && $_POST['provider'] === 'omdb') {

                $auth_key = get_option('streamit_'. $_POST['provider'] . '_auth');

                foreach ($_POST['data'] as $key => $value) {

                    $curlLink =  'https://www.omdbapi.com/?apikey='. $auth_key .'&type=' . $_POST['content_type'] . '&i=' . $value['imdbID'] ;

                    $apiResponse = wp_remote_get($curlLink);

                    $jsonArrayResponse = json_decode($apiResponse['body']);
                    
                    if(count($jsonArrayResponse) > 0) {

                        $id = wp_insert_post(array(
                            'post_title'    => $jsonArrayResponse->Title,
                            'post_type'     => $_POST['content_type'],
                            'post_content'  => $jsonArrayResponse->Plot ,
                            'post_status'   => 'publish'
                        ));

                        $thumbnail_post_id = $this->importUrlToMedia( $jsonArrayResponse->Poster, $id);

                        if ($_POST['content_type'] === 'movie') {
                            add_post_meta( $id, '_thumbnail_id' , $thumbnail_post_id );
                            add_post_meta( $id, '_imdb_id' ,  $jsonArrayResponse->imdbID );
                            add_post_meta( $id, '_' . $_POST['content_type'] . '_release_date' ,  current_time('timestamp') );
                            add_post_meta( $id, '_' . $_POST['content_type'] . '_censor_rating' ,  '0.0' );
                            add_post_meta( $id, '_' . $_POST['content_type'] . '_run_time' ,  $jsonArrayResponse->Runtime );
                        }

                    }

                }

            } elseif (isset($_POST['provider']) && $_POST['provider'] === 'csv') {
                
                if(isset($_POST['data']) && count($_POST['data']) > 0) {

                    foreach($_POST['data'] as $key => $row) {

                        $id = wp_insert_post(array(
                            'post_title'    => $row[0] ,
                            'post_type'     => $_POST['content_type'] ,
                            'post_content'  => $row[1] ,
                            'post_status'   => 'publish'
                        ));
                        
                        if ($_POST['content_type'] === 'movie') {
                            add_post_meta( $id, '_imdb_id' ,  $row[4] );
                            add_post_meta( $id, '_' . $_POST['content_type'] . '_release_date' ,  $row[2] );
                            add_post_meta( $id, '_' . $_POST['content_type'] . '_censor_rating' ,  $row[5] );
                            add_post_meta( $id, '_' . $_POST['content_type'] . '_run_time' ,    $row[3] );
                            add_post_meta( $id, '_' . $_POST['content_type'] . '_choice' , $_POST['content_type'] . '_embed' );
                            add_post_meta( $id, '_' . $_POST['content_type'] . '_embed_content' ,  $row[7] );
                            $thumbnail_post_id = $this->importUrlToMedia( $row[8], $id);
                            add_post_meta( $id, '_thumbnail_id' , $thumbnail_post_id );
                        } 

                        if ($_POST['content_type'] === 'video') { 

                            add_post_meta( $id, '_' . $_POST['content_type'] . '_choice' , $_POST['content_type'] . '_' . $row[2] );

                            if($row[2] === 'embed') {
                                add_post_meta( $id, '_' . $_POST['content_type'] . '_embed_content' ,  $row[3] );
                            }

                            if($row[2] === 'url') {
                                add_post_meta( $id, '_' . $_POST['content_type'] . '_url_link' ,  $row[3] );
                            }

                            $thumbnail_post_id = $this->importUrlToMedia( $row[4], $id);
                            add_post_meta( $id, '_thumbnail_id' , $thumbnail_post_id );

                        }
                    }
                }
            }

            elseif (isset($_POST['provider']) && $_POST['provider'] === 'tmdb') {

                $auth_key = get_option('streamit_' . $_POST['provider'] . '_auth');

                foreach ($_POST['data'] as $key => $value) {

                    $id=$value['id'];

                    $jsonArrayResponse = $this->streamit_tmdb_api($auth_key,$id,'detail');

                    $trailerJson=$this->streamit_tmdb_api($auth_key,$id,'video');

                    $siteType = $trailerJson->results[0]->site;

                    if (count($jsonArrayResponse) > 0) {

                        $id = wp_insert_post(array(
                            'post_title' => $jsonArrayResponse->original_title,
                            'post_type' => $_POST['content_type'],
                            'post_content' => $jsonArrayResponse->overview,
                            'post_status' => 'publish'
                        ));
                        
                        $poster='http://image.tmdb.org/t/p/original'.$value['backdrop_path'];
                        $thumbnail_post_id = $this->importUrlToMedia($poster, $id);

                        if ($_POST['content_type'] === 'movie') {
                            add_post_meta($id, '_thumbnail_id', $thumbnail_post_id);
                            add_post_meta($id, '_imdb_id', $jsonArrayResponse->imdb_id);
                            add_post_meta($id, '_tmdb_id', $value['id']);
                            add_post_meta($id, '_' . $_POST['content_type'] . '_release_date', current_time($jsonArrayResponse->release_date));
                            add_post_meta($id, '_' . $_POST['content_type'] . '_censor_rating', '0.0');
                            if($siteType === 'YouTube') {
                               // add_post_meta($id, '_' . $_POST['content_type'] . '_choice', $_POST['content_type'] . '_embed');
                                //add_post_meta($id, '_' . $_POST['content_type'] . '_embed_content', '<iframe width="1024" height="574" src="https://www.youtube.com/embed/' . $trailerJson->results[0]->key . '" allowfullscreen ></iframe>');
                                add_post_meta($id, 'name_trailer_link', 'https://www.youtube.com/watch?v='. $trailerJson->results[0]->key );
                            }

                            $hr = round($jsonArrayResponse->runtime / 60) ;
                            $min = ($jsonArrayResponse->runtime % 60);

                            add_post_meta($id, '_' . $_POST['content_type'] . '_run_time', $hr.'hr : ' . $min . 'mins');

                        }

                    }

                }
            }
            echo json_encode(array('status' => true, 'message' => 'Data import successfully.')); die;

        } catch (customException $e) {

            echo json_encode(array('status' => false, 'message' => 'Data not import successfully.')); die;

        }

    }

    public function readDataFromCsv () {

        $attachment_id = $_POST['attachment'] ;

        $attachment_url = wp_get_attachment_url($attachment_id);

        $_file = fopen($attachment_url, 'r');

        $lineNumber = 1 ;

        $data = [] ;

        while (($raw_string = fgets($_file)) !== false) {

            $row = str_getcsv($raw_string);
            
            if(count($row) > 0 && $lineNumber > 1) {
                $data[] = $row;
            }

            $lineNumber++;

        }

        wp_send_json(array('status' => true, 'message' => 'Data not import successfully.', 'data' => $data ), 200);

    }

    public function streamit_tmdb_api($key,$id,$type) {

        if($type === "detail") {
            $curlLink = 'https://api.themoviedb.org/3/movie/' . $id . '?api_key=' . $key . '&language=en-US';
        }
        elseif ($type === "video"){
            $curlLink = 'https://api.themoviedb.org/3/movie/' . $id . '/videos?api_key=' . $key . '&language=en-US';
        }

        $response = wp_remote_get($curlLink);

        return json_decode($response['body']);

    }

}
