<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php
		$content = apply_filters( 'streamit_the_content', get_the_content() );
		$audio = false;

		// Only get audio from the content if a playlist isn't present.
		if ( false === strpos( $content, 'wp-playlist-script' ) ) {
			$audio = get_media_embedded_in_content( $content, array( 'audio' ) );
		}
	?>
	<div class="iq-page-blog">
		<div class="iq-blog-box">	
			<?php
			$streamit_options = get_option('streamit_options');
			if(isset($streamit_options['streamit_display_image']))
			{
			$options = $streamit_options['streamit_display_image'];
			if($options == "yes"){
				if ( has_post_thumbnail() ) { ?>
				<div class="iq-blog-image">
				<?php
                if(is_single()){
                    the_content();
                }else{
                    the_excerpt();
                }

					wp_link_pages( array(
						'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'streamit' ),
						'after'       => '</div>',
						'link_before' => '<span class="page-number">',
						'link_after'  => '</span>',
					) );
					?>
				</div>	
				<?php } 
				} 
			}
			else 
			{
			?>
				<div class="iq-blog-image">
				<?php 
					the_content();

					wp_link_pages( array(
						'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'streamit' ),
						'after'       => '</div>',
						'link_before' => '<span class="page-number">',
						'link_after'  => '</span>',
					) );
					?>
				</div>	
			<?php
			}
			?>
			<div class="iq-blog-detail">
					<div class="iq-blog-meta">
						<ul class="list-inline">
                            <li class="list-inline-item">
                                <a href="<?php echo  sprintf("%s",get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ),'streamit'); ?>" class="iq-user">
                                    <i class="fa fa-user-o mr-1" aria-hidden="true"></i>
                                    <?php echo  sprintf("%s ",get_the_author(),'streamit'); ?>
                                </a>
                            </li>
							<?php 
							//post date
							$archive_year  = get_the_time('Y',$post->post_id);
							$archive_month = get_the_time('m',$post->post_id); 
							$archive_day   = get_the_time('d',$post->post_id);
							$date=date_create($post->post_date); ?>
							<li class="list-inline-item">
                                <i class="fa fa-calendar mr-1" aria-hidden="true"></i>
								<?php echo streamit_time_link(); ?>
							</li>							
						</ul>
					</div>
					<?php if(!is_single())
					{
					?>
					<div class="blog-title">
						<h3 class="entry-title">
							<a href="<?php echo esc_url(get_permalink($post->ID)); ?>">
								<?php the_title(); ?>
							</a>
						</h3>
					</div>
					<?php 
					}
					?>
					<?php if(!is_single()){ ?>
					<div class="blog-button">
					<?php 
					if(!empty($streamit_options['blog_btn']))
					{ 
					?>
					<a class="button-link" href="<?php the_permalink();?>"><?php echo esc_attr($streamit_options['blog_btn']); ?><i class="fa fa-angle-right" aria-hidden="true"></i></a>
					<?php 
					}
					else
					{ 
					?>
					<a class="button-link" href="<?php the_permalink();?>"><?php esc_html__('Read More', 'streamit'); ?><i class="fa fa-angle-right" aria-hidden="true"></i></a>
					<?php 
					}
					?>
					</div>
					<?php
					}
					?>							
			</div>	
		</div>	
	</div>
	<?php 
	$streamit_options = get_option('streamit_options');
	if(isset($streamit_options['streamit_display_comment']))
		{
		$options = $streamit_options['streamit_display_comment'];
		if($options == "yes")
		{
			if(is_single()){
				// If comments are open or we have at least one comment, load up the comment template.
				if ( comments_open() || get_comments_number() ) :
					comments_template();
				endif;

				streamit_pagination();
			}
		}
	}
	else {
		if(is_single()){
			// If comments are open or we have at least one comment, load up the comment template.
			if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif;

			streamit_pagination();
		}
		
	}
	?>
</article><!-- #post-## -->
