<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

class Iq_TV_Show_Slider extends Widget_Base
{

	public function get_name()
	{
		return __('Iq_TV_Show_Slider', "streamit-extensions");
	}

	public function get_title()
	{
		return __('Tv Show Slider/Grid', "streamit-extensions");
	}

	public function get_categories()
	{
		return ['streamit-extensions'];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve heading widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-person';
	}



	protected function _register_controls()
	{


		$this->start_controls_section(
			'section_Team',
			[
				'label' => __('Tv Show Banner Slider', "streamit-extensions"),
			]
		);
		$this->add_control(
			'slider_title',
			[
				'label' => __('Title', 'plugin-domain'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Title', 'plugin-domain'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'slider_type',
			[
				'label' => __('Tv Show Style', "streamit-extensions"),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => [
					'slider' => __('Slider', "streamit-extensions"),
					'grid' => __('Grid', "streamit-extensions")
				],
				'default' => 'slider'

			]
		);
		$this->add_control(
			'play_now_text',
			[
				'label' => __('Play Now Text', 'plugin-domain'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Play Now', 'plugin-domain'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'iq_select_tv_shows',
			[
				'label' => __('Select Tv Shows', "streamit-extensions"),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => iq_custom_post_data('tv_show', array(), 'id'),

			]
		);
		$this->add_control(
			'iq_tv_show_genre',
			[
				'label' => __('Display Tv Show From Specific Genre', "streamit-extensions"),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => iq_get_custom_texonomy('tv_show_genre'),

			]
		);

		$this->add_control(
			'iq_tv_show_tag',
			[
				'label' => __('Display Tv Show From Specific Tags', "streamit-extensions"),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => iq_get_custom_texonomy('tv_show_tag'),

			]
		);
		$this->add_control(
			'view_all_switch',
			[
				'label' => __('Use View All Button ?', 'plugin-domain'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'yes' => __('Yes', "streamit-extensions"),
				'no' => __('No', "streamit-extensions"),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);


		$this->add_control(
			'use_custom_link_viewall',
			[
				'label' => __('Use View All custom link ?', 'streamit-extensions'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'yes' => __('Yes', "streamit-extensions"),
				'no' => __('No', "streamit-extensions"),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => ['view_all_switch' => 'yes'],
			]
		);

		$this->add_control(
			'use_custom_link_text',
			[
				'label' => __('Custom Link Text', 'streamit-extensions'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Link Text', 'streamit-extensions'),
				'label_block' => true,
				'condition' => [
					'use_custom_link_viewall' => 'yes',
					'view_all_switch' => 'yes'
				],
			]
		);

		$this->add_control(
			'view_all_custom_link',
			[
				'label' => __('Custom link', 'streamit-extensions'),
				'type' => Controls_Manager::URL,
				'placeholder' => __('https://your-link.com', 'streamit-extensions'),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'use_custom_link_viewall' => 'yes',
					'view_all_switch' => 'yes'
				],
			]
		);
		$this->add_control(
			'video_grid_style',
			[
				'label'      => __('Tv Show Grid', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'default'    => '4',
				'options'    => [
					'1'            => __('One', 'streamit-extensions'),
					'2'          => __('Two', 'streamit-extensions'),
					'3'          => __('Three', 'streamit-extensions'),
					'4'          => __('Four', 'streamit-extensions'),
				],
				'condition' => ['slider_type' => 'grid']
			]
		);
		require IQ_TH_ROOT . '/inc/elementor/include/post-control.php';
		$this->add_control(
			'pagination',
			[
				'label'   => __('Show Pagintion/Loadmore/Infinite', 'streamit-extensions'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'loadmore',
				'options' => [
					'yes' => esc_html__('Pagination', 'streamit-extensions'),
					'loadmore' => esc_html__('Loadmore', 'streamit-extensions'),
					'infinite' => esc_html__('Infinite Scroll', 'streamit-extensions')
				],
				'condition' => ['slider_type' => 'grid']

			]
		);
		$this->add_control(
			'more_text',
			[
				'label' => __('Load More button text', 'streamit-extensions'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Load More', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['slider_type' => 'grid', 'pagination' => 'loadmore']
			]
		);
		$this->add_control(
			'loading_text',
			[
				'label' => __('Loading button text', 'streamit-extensions'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Loading...', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['slider_type' => 'grid', 'pagination' => 'loadmore']
			]
		);
		$this->add_responsive_control(
			'posts_per_page',
			[
				'label' => __('Posts Per Page', 'elementor'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => '%',
					'size' => -1,
				]
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'slick_control_section',
			[
				'label' => __('Slider Control', 'iqonic'),
				'condition' => ['slider_type' => ['slider']],

			]
		);

		require IQ_TH_ROOT . '/inc/elementor/register-custom-control/slick-control.php';


		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings();
		require  IQ_TH_ROOT . '/inc/elementor/render/tv-show-slider.php';
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new \Elementor\Iq_TV_Show_Slider());
