<?php

namespace Elementor;

$html = '';
if (!defined('ABSPATH')) exit;

$settings = $this->get_settings();
$tabs = $this->get_settings_for_display('tabs');
$streamit_options = get_option('streamit_options');
$id_int = rand(10, 100);

$this->add_render_attribute('slider', 'data-nav', $settings['nav-arrow']);
$this->add_render_attribute('slider', 'data-autoplay', $settings['autoplay']);
$this->add_render_attribute('slider', 'data-speed', $settings['speed']);
?>

<div class="iq-main-slider p-0 iq-rtl-direction iq-tvshows-slider">
    <div id="<?php echo esc_attr('tvshows-slider-' . $id_int); ?>" data-rand="<?php echo esc_attr('tvshows-slider-' . $id_int); ?>" class="tvshows-slider" <?php  echo $this->get_render_attribute_string('slider'); ?>>
        <?php
        foreach ($tabs as $index => $item) {

            $args = array(
                'post_type'         => array('tv_show', 'movie', 'video'),
                'post_status'       => 'publish',
            );
            if (!empty($item['iq_video']) && $item['iq_type'] === 'video') {
                $args['p'] = $item['iq_video'];
            }
            if (!empty($item['iq_tv_show']) && $item['iq_type'] === 'tv_show') {
                $args['p'] = $item['iq_tv_show'];
            }
            if (!empty($item['iq_movie']) && $item['iq_type'] === 'movie') {
                $args['p'] = $item['iq_movie'];
            }
            $wp_query = new \WP_Query($args);
            if ($wp_query->have_posts()) {
                while ($wp_query->have_posts()) {
                    $wp_query->the_post();
                    $back_img = get_field('movie_back_image', get_the_ID());
                    $movie_logo = get_field('name_logo', get_the_ID());
                    $trailer_link = get_field('name_trailer_link', get_the_ID());
                    $movie_run_time = get_post_meta(get_the_ID(), '_movie_run_time');
                    $video_run_time = get_post_meta(get_the_ID(), '_video_run_time');
                    $movie_url_link = get_post_meta(get_the_ID(), '_movie_url_link');
                    $movie_censor_rating = get_post_meta(get_the_ID(), '_movie_censor_rating');
                    $meta = get_post_meta(get_the_ID());
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id($wp_query->ID), "full");
                    if ($item['iq_type'] === 'video') {
                    } else {

                        $tm_imdb_rating = $meta['name_custom_imdb_rating'];
                        $imdb_rating = 0;
                        if (isset($tm_imdb_rating[0])) {
                            $imdb_rating = $tm_imdb_rating[0];
                            $imdb_text = '';
                            if ($streamit_options['streamit_imdb_display_rating'] === 'yes') {
                                if ($streamit_options['streamit_display_single_star'] === 'no') {
                                    $imdb_rating = $imdb_rating;
                                    $imdb_text = 'single_star';
                                }
                            } else {
                                $imdb_rating = floatval($imdb_rating) / 2;
                            }
                        }
                    }
                    $movie_release_year = get_post_meta(get_the_ID(), '_movie_release_date');
                    $year = '';
                    if (!empty($movie_release_year)) {
                        $year = date('M Y'. $movie_release_year[0]);
                    } else {
                        $year = get_the_date('M Y');
                    }

                    $run_time = '';
                    $run_video_time = '';
                    $url_link = '';
                    $censor_rating = '';
                    if (isset($movie_censor_rating[0])) {
                        $censor_rating = $movie_censor_rating[0];
                    }

                    if ($item['iq_type'] === 'video') {

                        if (isset($video_run_time[0])) {
                            $run_video_time = $video_run_time[0];
                        }
                    }
                    if (isset($movie_run_time[0])) {
                        $run_time = $movie_run_time[0];
                    }
                    if (isset($movie_url_link[0])) {
                        $url_link = $movie_url_link[0];
                    }

                    $meta = get_post_meta(get_the_ID());
                    if (get_post_type() === 'tv_show')
                        $season_data = unserialize($meta['_seasons'][0]);
        ?>
                    <div class="slick-bg" style="background:url(<?php
                                                                if (!empty($item['slider_image']['url'])) {
                                                                    echo esc_url($item['slider_image']['url']);
                                                                } else {
                                                                    if (has_post_thumbnail()) {
                                                                        echo esc_url($full_image[0]);
                                                                    }
                                                                } ?>)">
                        <div class="shows-content h-100">
                            <div class="row align-items-center h-100">
                                <div class="col-lg-7 col-md-12">
                                    <h1 class="slider-text big-title title text-uppercase" data-animation-in="fadeInLeft" data-delay-in="0.1"><?php the_title(); ?></h1>
                                    <?php if (!empty($item['iq_video']) && $item['iq_type'] === 'video') { ?>

                                        <div class="d-flex align-items-center tv-movie-banner text-detail" data-animation-in="fadeInUp" data-delay-in="0.3">
                                            <span class="badge badge-secondary p-1 mr-2">
                                                <?php
                                                if (function_exists('set_post_view')) {
                                                ?>
                                                    <i class="fa fa-eye"></i>
                                                <?php if (get_post_view() == 0) {
                                                        echo esc_html('0 Views');
                                                    } else {
                                                        echo get_post_view();
                                                    };
                                                }
                                                ?></span>
                                            <span class="span"><?php echo esc_html($run_video_time); ?></span>
                                            <span class="trending-year"><?php echo get_the_date('M Y'); ?></span>
                                        </div>

                                    <?php } else { ?>
                                        <?php if (isset($tm_imdb_rating[0]) && !empty($tm_imdb_rating[0])) { ?>
                                            <div class="slider-ratting d-flex align-items-center" data-animation-in="fadeInLeft">
                                                <ul class="ratting-start p-0 m-0 list-inline text-primary d-flex align-items-center justify-content-left">
                                                    <?php
                                                    if (isset($streamit_options['streamit_imdb_display_rating']) && $streamit_options['streamit_imdb_display_rating'] == 'yes' && $streamit_options['streamit_display_single_star'] == 'yes') {
                                                    ?>
                                                        <li>
                                                            <i class="fa fa-star" aria-hidden="true"></i>
                                                        </li>
                                                        <?php
                                                    } else {
                                                        for ($i = 1; $i <= ceil($imdb_rating); $i++) {
                                                            if (($imdb_rating - floor($imdb_rating)) > 0 && $i == ceil($imdb_rating)) {

                                                        ?>
                                                                <li>
                                                                    <i class="fa fa-star-half" aria-hidden="true"></i>
                                                                </li>
                                                            <?php
                                                                continue;
                                                            }
                                                            ?>
                                                            <li class="<?php esc_attr_e($imdb_text); ?>">
                                                                <i class="fa fa-star" aria-hidden="true"></i>
                                                            </li>
                                                    <?php
                                                        }
                                                    }
                                                    ?>
                                                </ul>
                                                <span class="text-white ml-3"><?php echo esc_html(round($imdb_rating, 1) . ' (lmdb)', "streamit-extensions"); ?></span>
                                            </div>
                                        <?php } ?>
                                        <div class="d-flex align-items-center tv-movie-banner text-detail" data-animation-in="fadeInUp" data-delay-in="0.3">
                                            <span class="badge badge-secondary p-2 mr-3"><?php echo esc_html($censor_rating, "streamit-extensions"); ?></span>
                                            <span class="">
                                                <?php
                                                $display = '';
                                                if (isset($season_data)) {
                                                    if (is_array($season_data)) {
                                                        $display = count($season_data) . ' Seasons';
                                                    } else {
                                                        $display = '1 Seasons';
                                                    }
                                                } elseif (isset($movie_run_time)) {
                                                    $display = $movie_run_time[0];
                                                }
                                                echo esc_html__($display, "streamit-extensions");
                                                ?>
                                            </span>
                                            <span class="trending-year"><?php echo esc_html($year, "streamit-extensions"); ?></span>
                                        </div>
                                    <?php } ?>
                                    <p data-animation-in="fadeInUp" data-delay-in="0.5">
                                        <?php

                                        $iq_excerpt = get_the_excerpt();
                                        if (!empty($iq_excerpt)) {
                                            $iq_remove_tags = array("<p>", "</p>");
                                            $iq_excerpt = str_replace($iq_remove_tags, "", $iq_excerpt);
                                            echo __($iq_excerpt, "streamit-extensions");
                                        }
                                        ?>
                                    </p>
                                    <?php
                                    if (isset($settings['show_view_all_btn'])) {
                                        if ($settings['show_view_all_btn'] == 'yes') {
                                    ?>
                                            <div class="d-flex align-items-center r-mb-23" data-animation-in="fadeInUp" data-delay-in="1.3">
                                                <a href="<?php the_permalink(); ?>" class="btn btn-hover iq-button"><i class="fa fa-play mr-2" aria-hidden="true"></i>
                                                    <?php
                                                    if (!empty($settings['play_now_text'])) {
                                                        echo esc_attr($settings['play_now_text'], 'streamit-extensions');
                                                    } else {
                                                        echo __('Play Now', 'streamit-extensions');
                                                    }
                                                    ?>
                                                </a>
                                            </div>
                                    <?php }
                                    }  ?>
                                </div>

                                <?php if ($settings['show_trailer_btn'] === 'yes') {

                                ?>
                                    <div class="col-lg-5 col-md-12 trailor-video iq-slider">
                                        <a href="<?php echo esc_url($trailer_link); ?>" class="video-open playbtn">
                                            <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="80px" height="80px" viewBox="0 0 213.7 213.7" enable-background="new 0 0 213.7 213.7" xml:space="preserve">
                                                <polygon class='triangle' fill="none" stroke-width="7" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" points="73.5,62.5 148.5,105.8 73.5,149.1 " />
                                                <circle class='circle' fill="none" stroke-width="7" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" cx="106.8" cy="106.8" r="103.3" />
                                            </svg>
                                            <?php
                                            if (!empty($settings['trailer_text'])) {
                                            ?>
                                                <span class="w-trailor"><?php echo esc_html($settings['trailer_text'], "streamit-extensions") ?></span>
                                            <?php }  ?>
                                        </a>
                                    </div>
                                <?php
                                } ?>


                            </div>
                        </div>
                    </div>
        <?php }
            }
        }


        ?>
    </div>
</div>