<?php

namespace Elementor;

use Elementor\Plugin;

if (!defined('ABSPATH')) exit;

$settings = $this->get_settings();
$options_streamit_load = $settings['pagination'];
$cat = '';
if (isset($settings['blog_cat']) && !empty($settings['blog_cat'])) {
	$cat = implode(',', $settings['blog_cat']);
}
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
$args = array(
	'post_type'         => 'post',
	'posts_per_page' 	=> $settings['posts_per_page']['size'],
	'paged'				=> $paged,
	'post_status'       => 'publish',
	'category_name'		=> $cat,
	'order'           	=> $settings['order'],
	'suppress_filters'  => 0
);
$align = $settings['align'];
// blog layouts	
$blog_layout = '';
$blog_art = '';
$wp_query = new \WP_Query($args);



global $post;
?>
<div class="iq-blog<?php echo esc_attr($align, "streamit-extensions") ?>">

	<?php
	if ($settings['blog_type'] === '1') {
		$desk = $settings['desk_number'];
		$lap = $settings['lap_number'];
		$tab = $settings['tab_number'];
		$mob = $settings['mob_number'];

		$this->add_render_attribute('slider', 'data-dots', $settings['dots']);
		$this->add_render_attribute('slider', 'data-nav', $settings['nav-arrow']);
		$this->add_render_attribute('slider', 'data-items', $settings['desk_number']);
		$this->add_render_attribute('slider', 'data-items-laptop', $settings['lap_number']);
		$this->add_render_attribute('slider', 'data-items-tab', $settings['tab_number']);
		$this->add_render_attribute('slider', 'data-items-mobile', $settings['mob_number']);
		$this->add_render_attribute('slider', 'data-items-mobile-sm', $settings['mob_number']);
		$this->add_render_attribute('slider', 'data-autoplay', $settings['autoplay']);
		$this->add_render_attribute('slider', 'data-loop', $settings['loop']);
		$this->add_render_attribute('slider', 'data-margin', $settings['margin']['size']);
		$this->add_render_attribute('slider', 'data-padding', $settings['padding']['size']);

	?>

		<div class="blog-carousel owl-carousel" <?php echo $this->get_render_attribute_string('slider') ?>>
			<?php

			if ($wp_query->have_posts()) {
				while ($wp_query->have_posts()) {
					$wp_query->the_post();
					$full_image = wp_get_attachment_image_src(get_post_thumbnail_id($wp_query->ID), "full");
			?>


					<div class="iq-blog-box">
						<div class="iq-blog-image clearfix">
							<?php echo sprintf('<img src="%1$s" alt="iqonic-blog"/>', esc_url($full_image[0], "streamit-extensions")); ?>


						</div>
						<div class="iq-blog-detail">
							<div class="blog-content-box">
								<div class="iq-blog-meta">
									<ul class="iq-postdate">
										<?php
										//post date
										$archive_year  = get_the_time('Y', $wp_query->ID);
										$archive_month = get_the_time('m', $wp_query->ID);
										$archive_day   = get_the_time('d', $wp_query->ID);
										$date = date_create($wp_query->post_date); ?>
										<li class="list-inline-item">
											<?php echo sprintf("%s", iqonic_blog_time_link()); ?>
										</li>

									</ul>

								</div>
								<?php $postcat = get_the_category();
								if ($postcat) {
								?>
									<ul class="iq-blogtag">
										<?php
										foreach ($postcat as $cat) {
										?>
											<li><a href="<?php echo get_category_link($cat->cat_ID); ?>"><?php echo $cat->name; ?></a></li>
										<?php
										}
										?>
									</ul>
								<?php
								}
								?>
							</div>
							<div class="blog-title">
								<<?php echo esc_attr($settings['title_tag']); ?> class="mb-3"><a href="<?php echo sprintf("%s", esc_url(get_permalink($wp_query->ID))); ?>">
										<?php echo sprintf("%s", esc_html__(get_the_title($wp_query->ID), "streamit-extensions")); ?>
									</a></<?php echo esc_attr($settings['title_tag']); ?>>


							</div>
							<p class="">
								<?php if ($post->post_excerpt) {
									the_excerpt();
								} else {
									the_content('', TRUE);
								}
								?>
							</p>
							<div class="blog-button">
								<a class="iq-btn-link" href="<?php echo sprintf("%s", esc_url(get_permalink($wp_query->ID))); ?>"><?php echo sprintf("%s", __('Read More', "streamit-extensions")); ?><i class="fa fa-angle-right ml-2" aria-hidden="true"></i></a>
							</div>
						</div>
					</div>


			<?php
				}
			}

			wp_reset_postdata();


			?>
		</div>


		<?php } else {
		echo '<div class="blog_main_contens">';
		echo '<div class="row blog_grid_contens streamit_datapass_blog_grid" data-options="' . esc_html($options_streamit_load) . '">';
		if ($settings['blog_style'] === "2") {
			$col = 'col-lg-12 iqonic-space-bottom';
		}
		if ($settings['blog_style'] === "3") {
			$col = 'col-lg-6 col-md-6 iqonic-space-bottom';
		}
		if ($settings['blog_style'] === "4") {
			$col = 'col-lg-4 col-md-6 iqonic-space-bottom';
		}
		if ($wp_query->have_posts()) {
			while ($wp_query->have_posts()) {
				$wp_query->the_post();
				$full_image = wp_get_attachment_image_src(get_post_thumbnail_id($wp_query->ID), "full");

		?>
				<div class="<?php echo esc_attr__($col, "streamit-extensions") ?>">
					<div class="iq-blog-box">
						<div class="iq-blog-image clearfix">
							<?php echo sprintf('<img src="%1$s" alt="iqonic-blog"/>', esc_url($full_image[0], "streamit-extensions")); ?>
						</div>
						<div class="iq-blog-detail">
							<div class="d-flex">
								<div class="iq-blog-meta">

									<ul class="iq-postdate">
										<?php
										//post date
										$archive_year  = get_the_time('Y', $wp_query->ID);
										$archive_month = get_the_time('m', $wp_query->ID);
										$archive_day   = get_the_time('d', $wp_query->ID);
										$date = date_create($wp_query->post_date); ?>
										<li class="list-inline-item">

											<?php echo sprintf("%s", iqonic_blog_time_link()); ?>
										</li>

									</ul>

								</div>
								<?php
								$postcat = get_the_category();
								if ($postcat) {
								?>
									<ul class="iq-blogtag">
										<?php
										foreach ($postcat as $cat) {
										?>
											<li><a href="<?php echo get_category_link($cat->cat_ID); ?>"><?php echo $cat->name; ?></a></li>
										<?php
										}
										?>
									</ul>
								<?php
								}
								?>
							</div>
							<div class="blog-title">
								<<?php echo esc_attr($settings['title_tag']); ?> class="mb-3"><a href="<?php echo sprintf("%s", esc_url(get_permalink($wp_query->ID))); ?>">
										<?php echo sprintf("%s", esc_html__(get_the_title($wp_query->ID), "streamit-extensions")); ?>
									</a></<?php echo esc_attr($settings['title_tag']); ?>>

							</div>
							<p class="">
								<?php if ($post->post_excerpt) {
									the_excerpt();
								} else {
									the_content('', TRUE);
								}
								?>
							</p>
							<div class="blog-button">
								<a class="iq-btn-link" href="<?php echo sprintf("%s", esc_url(get_permalink($wp_query->ID))); ?>"><?php echo sprintf("%s", __('Read More', "streamit-extensions")); ?><i class="fa fa-angle-right ml-2" aria-hidden="true"></i></a>
							</div>
						</div>
					</div>
				</div>
	<?php
			}
		}
		wp_reset_postdata();
		echo '</div>';
		echo '</div>';
	} ?>
</div>

<?php
if ($settings['blog_type'] != '1') {
	$total_pages = $wp_query->max_num_pages;
	$total_pages = $wp_query->max_num_pages;
	if ($settings['pagination'] == 'yes') {
		if ($total_pages > 1) {
			$current_page = max(1, get_query_var('paged'));
			echo paginate_links(array(
				'base' => get_pagenum_link(1) . '%_%',
				'format' => '/page/%#%',
				'current' => $current_page,
				'total' => $total_pages,
				'type'            => 'list',
				'prev_text'       => wp_kses('<span aria-hidden="true">' . __('Previous page', "streamit-extensions") . '</span>', "streamit-extensions"),
				'next_text'       => wp_kses('<span aria-hidden="true">' . __('Next page', "streamit-extensions") . '</span>', "streamit-extensions"),
			));
		}
	}
	if ($settings['pagination'] == 'loadmore') {
		if ($total_pages > 1) {
			echo '<a class="streamit_loadmore_btn_' . $this->get_id() . ' btn btn-hover iq-button" tabindex="0" data-loading-text="' . $settings['loading_text'] . '">
			<span>' . $settings['more_text'] . '</span>
		</a>';
		}
	}
	if ($settings['pagination'] == 'infinite') {
		if ($total_pages > 1) {
			echo '<div class="loader-wheel-container">                                                                   
		</div>';
		}
	}
}
?>
<script>
	jQuery(document).ready(function() {
		if (jQuery('.iq-default-blog-style-2 .blog-carousel').length > 0) {
			var scrWidth = jQuery(window).width();
			jQuery('.iq-default-blog-style-2 .blog-carousel').each(function() {
				if (scrWidth >= 1199) {
					if (jQuery(this).data('items') > 1) {

						jQuery(this).parent('.iq-blog').removeClass('iq-default-blog-style-2');
						jQuery(this).parent('.iq-blog').addClass('iq-default-blog-style-2-grid');
					}
				} else if (scrWidth >= 1023) {
					if (jQuery(this).data('items-laptop') > 1) {
						jQuery(this).parent('.iq-blog').removeClass('iq-default-blog-style-2');
						jQuery(this).parent('.iq-blog').addClass('iq-default-blog-style-2-grid');
					}
				} else if (scrWidth < 786) {

					jQuery(this).parent('.iq-blog').removeClass('iq-default-blog-style-2');
					jQuery(this).parent('.iq-blog').addClass('iq-default-blog-style-2-grid');
				}
			});
		}
	});
</script>
<?php if ($settings['blog_type'] == '2' && $settings['pagination'] == 'loadmore') { ?>
	<script>
		jQuery('.streamit_loadmore_btn_<?php echo $this->get_id() ?>').click(function() {
			let button = jQuery(this);
			let button_load = jQuery(this).attr('data-loading-text');
			let button_text = jQuery(this).text();
			let parentList = button.parent().find('.blog_grid_contens');


			let data = {
				'action': 'loadmore_blog_grid',
				'query': streamit_loadmore_params.posts, // that's how we get params from wp_localize_script() function
				'page': streamit_loadmore_params.current_page,
				'setting': <?php echo json_encode($this->get_settings()); ?>
			};

			jQuery.ajax({ // you can also use jQuery.post here
				url: streamit_loadmore_params.ajaxurl, // AJAX handler
				data: data,
				type: 'POST',
				beforeSend: function(xhr) {
					button.text(button_load); // change the button text, you can also add a preloader image
				},
				success: function(data) {
					if (data) {
						button.text(button_text)
						parentList.append(data); // insert new posts
						streamit_loadmore_params.current_page++;

						if (streamit_loadmore_params.current_page == streamit_loadmore_params.max_page) {
							button.remove(); // if last page, remove the button
						}

					} else {
						button.remove(); // if no data, remove the button as well
					}
				}
			});
		});
	</script>
<?php } ?>
<?php if ($settings['blog_type'] == '2' && $settings['pagination'] == 'infinite') { ?>
	<script>
		jQuery(function(jQuery) {
			var canBeLoaded = true,
				bottomOffset = 2000; // the distance (in px) from the page bottom when you want to load more posts

			var streamit_options = jQuery('.streamit_datapass_blog_grid').data('options');
			if (streamit_options == "infinite") {
				jQuery(window).scroll(function() {
					let button = jQuery(this);
					let parentList = button.parent().find('.blog_grid_contens');

					//** search load more *//
					let data = {
						'action': 'loadmore_blog_grid',
						'query': streamit_loadmore_params.posts,
						'page': streamit_loadmore_params.current_page,
						'setting': <?php echo json_encode($this->get_settings()); ?>
					};

					if (jQuery(document).scrollTop() > (jQuery(document).height() - bottomOffset) && canBeLoaded == true) {

						jQuery.ajax({
							url: streamit_loadmore_params.ajaxurl,
							data: data,
							type: 'POST',
							beforeSend: function(xhr) {
								canBeLoaded = false;
							},
							success: function(data) {
								if (data) {
									jQuery(".loader-wheel-container").html('<div class="loader-wheel"><i><i><i><i><i><i><i><i><i><i><i><i></i></i></i></i></i></i></i></i></i></i></i></i></div>');
									jQuery('.blog_main_contens').find('.blog_grid_contens').append(data); // where to insert posts
									canBeLoaded = true; // the ajax is completed, now we can run it again
									streamit_loadmore_params.current_page++;
								} else {
									jQuery(".loader-wheel-container").html('');
								}

							}
						});
					}


				});

			} else {
				//nothing to call
			}
		});
	</script>
<?php } ?>