<?php

    // load all files from app folder
    foreach(glob(plugin_dir_path( __FILE__ ) . 'app' .'/*.php') as $file) {

        require_once ( $file );

    }

    Class ClassStreamitRouteHelper {

        public function init () {
        }

        public function request ($request_route)  {

            $route = $this->streamitRoutes($request_route['streamit_route']);
            $this->routeCall($route['class'], $route['function']);

        }

        public function streamitRoutes ($request_route): array {

            // register route here
            $routes =  [
                'save_developer_key_function'     =>  [ 'class' => 'ClassStreamitDataImport', 'function' => 'saveDeveloperKey' ],
                'import_from_youtube'             =>  [ 'class' => 'ClassStreamitDataImport', 'function' => 'importFromYouTube'],
                'read_data_from_csv'              =>  [ 'class' => 'ClassStreamitDataImport', 'function' => 'readDataFromCsv'],
            ];

            if(isset($routes[$request_route])) {
                return $routes[$request_route] ;
            } else {
                echo json_encode(array('status' => false, 'message' => 'Requested route not found.')); die;
            }

        }

        public function routeCall ($class, $function) {

            ( new $class )->$function(); die;

        }

    }

