/*
Template: Streamit - Responsive Bootstrap 4 Template
Author: iqonicthemes.in
Design and Developed by: iqonicthemes.in
NOTE: This file contains the styling for responsive Template.
*/

/*----------------------------------------------
Index Of Script
------------------------------------------------
:: infinite Scroll
:: loadmore

------------------------------------------------
Index Of Script
----------------------------------------------*/

jQuery(document).ready(function ($) {
	// LoadMore 
	
	//viewall AJAX CALL
	jQuery('.streamit_loadmore_btn_viewall').click(function () {
		var button_load = jQuery(this).attr('data-loading-text');
		var button_text = jQuery(this).text();
		let url = window.location.href;
		var button = jQuery(this),
			data = {
				'action': 'loadmore_viewall',
				'query': streamit_loadmore_params.posts, // that's how we get params from wp_localize_script() function
				'page': streamit_loadmore_params.current_page,
				'href': url,
			};

		jQuery.ajax({ // you can also use jQuery.post here
			url: streamit_loadmore_params.ajaxurl, // AJAX handler
			data: data,
			type: 'POST',
			beforeSend: function (xhr) {
				button.text(button_load); // change the button text, you can also add a preloader image
			},
			success: function (data) {
				if (data) {
					button.text(button_text).prev().append(data); // insert new posts
					streamit_loadmore_params.current_page++;

					if (streamit_loadmore_params.current_page == streamit_loadmore_params.max_page)
						button.remove(); // if last page, remove the button

				} else {
					button.remove(); // if no data, remove the button as well
				}
			}
		});

	});
	//watchlist ALL AJAX CALL
	jQuery('.streamit_loadmore_btn_watchlist').click(function () {
		var button_load = jQuery(this).attr('data-loading-text');
		var button_text = jQuery(this).text();
		var button = jQuery(this),
			data = {
				'action': 'loadmore_watchlist',
				'query': streamit_loadmore_params.posts, // that's how we get params from wp_localize_script() function
				'page': streamit_loadmore_params.current_page
			};

		jQuery.ajax({ // you can also use jQuery.post here
			url: streamit_loadmore_params.ajaxurl, // AJAX handler
			data: data,
			type: 'POST',
			beforeSend: function (xhr) {
				button.text(button_load); // change the button text, you can also add a preloader image
			},
			success: function (data) {
				if (data) {
					button.text(button_text).parent().prev().after(data); // insert new posts
					streamit_loadmore_params.current_page++;

					if (streamit_loadmore_params.current_page == streamit_loadmore_params.max_page)
						button.remove(); // if last page, remove the button

				} else {
					button.remove(); // if no data, remove the button as well
				}
			}
		});

	});

	// Infinite Scroll 
	jQuery(function (jQuery) {

		var canBeLoaded = true,
			bottomOffset = 2000; // the distance (in px) from the page bottom when you want to load more posts

		var streamit_options = jQuery('.streamit_datapass_viewall').data('options');
		var streamit_options_watchlist = jQuery('.streamit_datapass_watchlist').data('options');


		if (streamit_options == "infinite_scroll") {

			jQuery(window).scroll(function () {
				
				//** search load more *//
				var data = {
					'action': 'loadmore_viewall',
					'query': streamit_loadmore_params.posts,
					'page': streamit_loadmore_params.current_page
				};

				if (jQuery(document).scrollTop() > (jQuery(document).height() - bottomOffset) && canBeLoaded == true) {

					jQuery.ajax({
						url: streamit_loadmore_params.ajaxurl,
						data: data,
						type: 'POST',
						beforeSend: function (xhr) {
							canBeLoaded = false;
						},
						success: function (data) {
							if (data) {
								jQuery(".loader-wheel-container").html('<div class="loader-wheel"><i><i><i><i><i><i><i><i><i><i><i><i></i></i></i></i></i></i></i></i></i></i></i></i></div>');
								jQuery('.viewall-list').find('article:last-of-type').after(data); // where to insert posts
								canBeLoaded = true; // the ajax is completed, now we can run it again
								streamit_loadmore_params.current_page++;
							} else {
								jQuery(".loader-wheel-container").html('');
							}

						}
					});
				}


			});

		}
		if (streamit_options_watchlist == "infinite_scroll") {

			jQuery(window).scroll(function () {

				//** search load more *//
				var data = {
					'action': 'loadmore_watchlist',
					'query': streamit_loadmore_params.posts,
					'page': streamit_loadmore_params.current_page
				};

				if (jQuery(document).scrollTop() > (jQuery(document).height() - bottomOffset) && canBeLoaded == true) {

					jQuery.ajax({
						url: streamit_loadmore_params.ajaxurl,
						data: data,
						type: 'POST',
						beforeSend: function (xhr) {
							canBeLoaded = false;
						},
						success: function (data) {
							if (data) {
								jQuery(".loader-wheel-container").html('<div class="loader-wheel"><i><i><i><i><i><i><i><i><i><i><i><i></i></i></i></i></i></i></i></i></i></i></i></i></div>');
								jQuery('.infinite_watchlist').prev().after(data); // where to insert posts
								canBeLoaded = true; // the ajax is completed, now we can run it again
								streamit_loadmore_params.current_page++;
							} else {
								jQuery(".loader-wheel-container").html('');
							}

						}
					});
				}


			});

		}
		else {
			//nothing to call
		}
	});
});
